% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphing.R
\name{plot_freq}
\alias{plot_freq}
\title{plot frequency distribution by geo-location per species}
\usage{
plot_freq(dt.freq, out.species = "all")
}
\arguments{
\item{dt.freq}{a table with class "cfs_freq", resulting from function CFS_freq()}

\item{out.species}{species list, default is 'all' to output the frequency distribution for all species}
}
\value{
A list of \code{ggplot} objects corresponding to the species
requested via \code{out.species}. Each element of the list contains
a faceted spatial plot of tree locations, with point size proportional
to the number of samples.
}
\description{
This function plots the frequency distribution by geo-location for each species
}
\examples{

# loading processed data
dt.samples_trt <- readRDS(system.file("extdata", "dt.samples_trt.rds", package = "growthTrendR"))
dt.freq <- CFS_freq(
dt.samples_trt$tr_all_wide,
freq.label_data = "demo-samples",
freq.uid_level = "uid_radius")

plots.lst <- plot_freq(dt.freq)


}
