% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_garch.R
\name{hanr_garch}
\alias{hanr_garch}
\title{Anomaly detector using GARCH}
\usage{
hanr_garch()
}
\value{
\code{hanr_garch} object.
}
\description{
Fits a GARCH model to capture conditional heteroskedasticity and flags
observations with large standardized residuals as anomalies. Wraps \code{rugarch}.
}
\details{
A sGARCH(1,1) with ARMA(1,1) mean is estimated. Standardized residuals are
summarized and thresholded via \code{harutils()}.
}
\examples{
library(daltoolbox)

# Load anomaly example data
data(examples_anomalies)

# Use a simple example
dataset <- examples_anomalies$simple
head(dataset)

# Configure GARCH anomaly detector
model <- hanr_garch()

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected anomalies
print(detection[(detection$event),])

}
\references{
\itemize{
\item Engle RF (1982). Autoregressive Conditional Heteroscedasticity with Estimates of
the Variance of United Kingdom Inflation. Econometrica, 50(4):987–1007.
\item Bollerslev T (1986). Generalized Autoregressive Conditional Heteroskedasticity.
Journal of Econometrics, 31(3):307–327.
}
}
