% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaWO_adhce.R
\name{deltaWO.adhce}
\alias{deltaWO.adhce}
\title{Win odds calculation based on a threshold for \code{adhce} objects}
\usage{
\method{deltaWO}{adhce}(x, delta, ref = unique(x$TRTP)[1], alpha = 0.05, WOnull = 1, ...)
}
\arguments{
\item{x}{an \code{adhce} object.}

\item{delta}{a numeric threshold.}

\item{ref}{the reference treatment group.}

\item{alpha}{significance level. The default is 0.05.}

\item{WOnull}{the null hypothesis. The default is 1.}

\item{...}{additional parameters.}
}
\value{
a data frame containing the win odds and its confidence interval. It contains the following columns:
\itemize{
\item WO calculated win odds.
\item LCL lower confidence limit.
\item UCL upper confidence limit.
\item SE standard error of the win odds.
\item WOnull win odds of the null hypothesis (specified in the \code{WOnull} argument).
\item alpha two-sided significance level for calculating the confidence interval (specified in the \code{alpha} argument).
\item Pvalue p-value associated with testing the null hypothesis.
\item WP calculated win probability.
\item LCL_WP lower confidence limit for \code{WP}.
\item UCL_WP upper confidence limit for \code{WP}.
\item SE_WP standard error of the win probability.
\item SD_WP standard deviation of the win probability, calculated as \code{SE_WP} multiplied by \code{sqrt(N)}.
\item N total number of patients in the analysis.
\item ref the reference group.
\item delta the threshold.
}
}
\description{
Win odds calculation based on a threshold for \code{adhce} objects
}
\examples{
# Example using the kidney dataset
dat <- as_hce(KHCE)
calcWO(dat, ref = "P")
## The exact same result
deltaWO(dat, delta = 0, ref = "P")
## A large threshold
deltaWO(dat, delta = 10, ref = "P")

}
\seealso{
\code{\link[=deltaWO]{deltaWO()}}, \code{\link[=calcWO]{calcWO()}}.
}
