% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprague.R
\name{sprague}
\alias{sprague}
\title{Sprague Index (Multipliers)}
\usage{
sprague(x)
}
\arguments{
\item{x}{numeric vector of population counts in five-year age intervals.
Must have exactly 17 elements corresponding to age groups 0-4, 5-9, ...,
75-79, 80+.}
}
\value{
A named numeric vector with 81 elements: single-year population
  counts for ages 0, 1, 2, ..., 79, and the 80+ group.
}
\description{
The Sprague method uses multipliers to estimate population counts for each
single year of age from 5-year interval data. This is useful for creating
smooth single-year age distributions from grouped census data.
}
\details{
Disaggregate 5-year age group counts into single-year ages using Sprague
multipliers.


The input must be population counts for 17 five-year age groups:
0-4, 5-9, 10-14, 15-19, 20-24, 25-29, 30-34, 35-39, 40-44, 45-49,
50-54, 55-59, 60-64, 65-69, 70-74, 75-79, and 80+.

The Sprague multipliers are applied differently depending on the position
of the age group:
\itemize{
  \item \strong{Lowest groups} (0-4): Uses only following age groups
  \item \strong{Low groups} (5-9): Uses mostly following age groups
  \item \strong{Normal groups} (10-74): Uses symmetric weighting
  \item \strong{High groups} (75-79): Uses mostly preceding age groups
  \item \strong{Highest groups} (80+): Returned as-is (open-ended)
}

The total population is preserved: sum of output equals sum of input.
}
\examples{
# Example from World Bank data
x <- data.frame(
  age = as.factor(c(
    "0-4", "5-9", "10-14", "15-19", "20-24",
    "25-29", "30-34", "35-39", "40-44", "45-49",
    "50-54", "55-59", "60-64", "65-69", "70-74", "75-79", "80+"
  )),
  pop = c(
    1971990, 2095820, 2157190, 2094110, 2116580,
    2003840, 1785690, 1502990, 1214170, 796934,
    627551, 530305, 488014, 364498, 259029, 158047, 125941
  )
)

# Apply Sprague multipliers
s <- sprague(x$pop)
head(s, 20)  # First 20 single-year ages

# Verify population is preserved
all.equal(sum(s), sum(x$pop))

}
\references{
Calot, G. and Sardon, J.-P. (1998). \emph{Methodology for the calculation of
Eurostat's demographic indicators}. Detailed report by the European
Demographic Observatory.

Sprague, T. B. (1880). Explanation of a new formula for interpolation.
\emph{Journal of the Institute of Actuaries}, \strong{22}, 270-285.
}
\seealso{
\code{\link{whipple}} for measuring age heaping.
}
\author{
Matthias Templ
}
\concept{graduation methods}
