% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-schema-versions.R
\name{version_equal}
\alias{version_equal}
\alias{version_gte}
\alias{version_gt}
\alias{version_lte}
\alias{version_lt}
\title{Compare hub config \code{schema_version}s to specific version numbers from
a variety of sources}
\usage{
version_equal(
  version,
  config = NULL,
  config_path = NULL,
  hub_path = NULL,
  schema_version = NULL
)

version_gte(
  version,
  config = NULL,
  config_path = NULL,
  hub_path = NULL,
  schema_version = NULL
)

version_gt(
  version,
  config = NULL,
  config_path = NULL,
  hub_path = NULL,
  schema_version = NULL
)

version_lte(
  version,
  config = NULL,
  config_path = NULL,
  hub_path = NULL,
  schema_version = NULL
)

version_lt(
  version,
  config = NULL,
  config_path = NULL,
  hub_path = NULL,
  schema_version = NULL
)
}
\arguments{
\item{version}{Character string. Version number to compare against, must be in
the format \code{"v#.#.#"}.}

\item{config}{A \verb{<config>} class object. Usually the output of \code{read_config} or \code{read_config_file}.}

\item{config_path}{Either a character string of a path to a local JSON config
file, a character string of the URL to the \strong{raw contents} of a JSON config
file (e.g on GitHub) or
an object of class \verb{<SubTreeFileSystem>} created using functions
\code{\link[arrow:s3_bucket]{arrow::s3_bucket()}} and associated methods for creating paths to JSON config
files within the bucket.}

\item{hub_path}{Either a character string path to a local Modeling Hub directory,
a character string of a URL to a GitHub repository
or an object of class \verb{<SubTreeFileSystem>} created using functions \code{\link[arrow:s3_bucket]{arrow::s3_bucket()}}
or \code{\link[arrow:gs_bucket]{arrow::gs_bucket()}} by providing a string S3 or GCS bucket name or path to a
Modeling Hub directory stored in the cloud.
For more details consult the
\href{https://arrow.apache.org/docs/r/articles/fs.html}{Using cloud storage (S3, GCS)}
in the \code{arrow} package.}

\item{schema_version}{Character string. A config \code{schema_version} property to
compare against.}
}
\value{
\code{TRUE} or \code{FALSE} depending on how the schema version compares to the
version number specified.
}
\description{
Compare hub config \code{schema_version}s to specific version numbers from
a variety of sources
}
\section{Functions}{
\itemize{
\item \code{version_equal()}: Check whether a schema version property is equal
to a specific version number.

\item \code{version_gte()}: Check whether a schema version property is equal to
or greater than a specific version number.

\item \code{version_gt()}: Check whether a schema version property is greater
than a specific version number.

\item \code{version_lte()}: Check whether a schema version property is equal to
or less than a specific version number.

\item \code{version_lt()}: Check whether a schema version property is less
than a specific version number.

}}
\examples{
# Actual version "v2.0.0"
hub_path <- system.file("testhubs/simple", package = "hubUtils")
# Actual version "v3.0.0"
config_path <- system.file("config", "tasks.json", package = "hubUtils")
config <- read_config_file(config_path)
schema_version <- config$schema_version
# Check whether schema_version equal to v3.0.0
version_equal("v3.0.0", config = config)
version_equal("v3.0.0", config_path = config_path)
version_equal("v3.0.0", hub_path = hub_path)
version_equal("v3.0.0", schema_version = schema_version)
# Check whether schema_version equal to or greater than v3.0.0
version_gte("v3.0.0", config = config)
version_gte("v3.0.0", config_path = config_path)
version_gte("v3.0.0", hub_path = hub_path)
version_gte("v3.0.0", schema_version = schema_version)
# Check whether schema_version greater than v3.0.0
version_gt("v3.0.0", config = config)
version_gt("v3.0.0", config_path = config_path)
version_gt("v3.0.0", hub_path = hub_path)
version_gt("v3.0.0", schema_version = schema_version)
# Check whether schema_version equal to or less than v3.0.0
version_lte("v3.0.0", config = config)
version_lte("v3.0.0", config_path = config_path)
version_lte("v3.0.0", hub_path = hub_path)
version_lte("v3.0.0", schema_version = schema_version)
# Check whether schema_version less than v3.0.0
version_lt("v3.0.0", config = config)
version_lt("v3.0.0", config_path = config_path)
version_lt("v3.0.0", hub_path = hub_path)
version_lt("v3.0.0", schema_version = schema_version)
}
