% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{test<-}
\alias{test<-}
\title{Attach unit tests to objects}
\usage{
test(f) <- value
}
\arguments{
\item{f}{the function (object) to which the tests are to be attached}

\item{value}{the test code, a function with no parameters}
}
\value{
\code{f} with the test attached as attribute \code{"test"}
}
\description{
This function attaches unit tests in \code{value} to an object (typically a
function) as an attribute \code{"test"}.
}
\examples{
f <- function(x) x^2

test(f) <- function() {
   context("f")

   test_that("correct result for complex number", {
     expect_equal(f(1i), -1 + 0i)
   })
}
}
