% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scour.R
\name{scour_vert}
\alias{scour_vert}
\title{Scour depth and length (vertical jet)}
\usage{
scour_vert(
  Q, B, h, h_u, d90, d95, ful_ov, method = "Kolatus", bedload = FALSE
)
}
\arguments{
\item{Q}{flow [m3/s]}

\item{B}{width of the overfall section [m]}

\item{h}{difference between upstream and downstream water table [m]}

\item{h_u}{downstream water table [m]}

\item{d90}{d90 of grain size distribution [mm]}

\item{d95}{d95 of grain size distribution [mm]}

\item{ful_ov}{defines if the overfall is complete or incomplete. TRUE and FALSE are valid values
[logical]}

\item{method}{method to calculate scour depth. valid values are "Kolatus" or "Tschopp".
Independent of the chosen method, the position of the scour is calculated
according to "Kolatus" and the scour depth considering bedload is calculated
according to "Tschopp".}

\item{bedload}{Consider bedload transportation. If bedload = TRUE, the scour depth "TG" and
"SG" are calculated additionally which consider bedload transport.}
}
\value{
\item{T0}{water table at maximal scour depth [m]}
\item{S}{maximal scour depth [m]}
\item{TG}{water table at maximal scour depth considering bedload transport
  [m]}
\item{SG}{maximal scour depth considering bedload transport [m]}
\item{l1}{horizontal distance of maximal scour depth to overfall crest [m]}
\item{l2}{total horizontal distance of scour depth from overfall crest [m]}
}
\description{
Calculate scour depth and position (length) formed by vertical jet
}
\examples{
## calculate scour depth according to Kolatus returning all results
scour_vert(
  Q = 4, B = 1, h = 3, h_u = 1.76, d90 = 150, d95 = 200, ful_ov = TRUE
)

## calculate scour depth according to Tschopp
scour_vert(
  Q = 4, B = 1, h = 3, h_u = 1.76, d90 = 150, d95 = 200,
  method = "Tschopp", ful_ov = TRUE
)$S

## calculate scour depth according to Tschopp considering bedload transport
scour_vert(
  Q = 4, B = 1, h = 3, h_u = 1.76, d90 = 150, d95 = 200,
  method = "Tschopp", bedload = TRUE, ful_ov = TRUE
)$SG

}
\references{
Bezzola (2012). Vorlesungsmanuskript Flussbau. ETH Zürich.
}
