% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_vis.R
\name{vis.immunr_ov_matrix}
\alias{vis.immunr_ov_matrix}
\alias{vis.immunr_gu_matrix}
\title{Repertoire overlap and gene usage visualisations}
\usage{
\method{vis}{immunr_ov_matrix}(.data, .plot = c("heatmap", "heatmap2", "circos"), ...)
}
\arguments{
\item{.data}{Output from \link{repOverlap} or \link{geneUsageAnalysis}.}

\item{.plot}{A string specifying the plot type:
\itemize{
\item "heatmap" for heatmaps using \link{vis_heatmap};
\item "heatmap2" for heatmaps using \link{vis_heatmap2};
\item "circos" for circos plots using \link{vis_circos};
}}

\item{...}{Other arguments are passed through to the underlying plotting function:
\itemize{
\item "heatmap" - passes arguments to \link{vis_heatmap};
\item "heatmap2" - passes arguments to \link{vis_heatmap2} and \link{heatmap} from the "pheatmap" package;
\item "circos" - passes arguments to \link{vis_circos} and \link[circlize:chordDiagram]{circlize::chordDiagram} from the "circlize" package;
}}
}
\value{
A ggplot2, pheatmap or circlize object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Visualises matrices with overlap values or gene usage distances among samples.
For details see the links below.
}
\examples{
\dontrun{
data(immdata)
ov <- repOverlap(immdata$data)
vis(ov)
vis(ov, "heatmap")
vis(ov, "heatmap2")
vis(ov, "circos")
}
}
\concept{overlap}
