% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferCSN.R
\docType{methods}
\name{inferCSN}
\alias{inferCSN}
\alias{inferCSN,matrix-method}
\alias{inferCSN,sparseMatrix-method}
\alias{inferCSN,data.frame-method}
\title{inferring cell-type specific gene regulatory network}
\usage{
inferCSN(
  object,
  penalty = "L0",
  cross_validation = FALSE,
  seed = 1,
  n_folds = 5,
  subsampling_method = c("sample", "meta_cells", "pseudobulk"),
  subsampling_ratio = 1,
  r_squared_threshold = 0,
  regulators = NULL,
  targets = NULL,
  cores = 1,
  verbose = TRUE,
  ...
)

\S4method{inferCSN}{matrix}(
  object,
  penalty = "L0",
  cross_validation = FALSE,
  seed = 1,
  n_folds = 5,
  subsampling_method = c("sample", "meta_cells", "pseudobulk"),
  subsampling_ratio = 1,
  r_squared_threshold = 0,
  regulators = NULL,
  targets = NULL,
  cores = 1,
  verbose = TRUE,
  ...
)

\S4method{inferCSN}{sparseMatrix}(
  object,
  penalty = "L0",
  cross_validation = FALSE,
  seed = 1,
  n_folds = 5,
  subsampling_method = c("sample", "meta_cells", "pseudobulk"),
  subsampling_ratio = 1,
  r_squared_threshold = 0,
  regulators = NULL,
  targets = NULL,
  cores = 1,
  verbose = TRUE,
  ...
)

\S4method{inferCSN}{data.frame}(
  object,
  penalty = "L0",
  cross_validation = FALSE,
  seed = 1,
  n_folds = 5,
  subsampling_method = c("sample", "meta_cells", "pseudobulk"),
  subsampling_ratio = 1,
  r_squared_threshold = 0,
  regulators = NULL,
  targets = NULL,
  cores = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{The input data for \code{inferCSN}.}

\item{penalty}{The type of regularization, default is \code{"L0"}.
This can take either one of the following choices: \code{"L0"}, \code{"L0L1"}, and \code{"L0L2"}.
For high-dimensional and sparse data, \code{"L0L2"} is more effective.}

\item{cross_validation}{Whether to use cross-validation.
Default is \code{FALSE}.}

\item{seed}{The random seed for cross-validation.
Default is \code{1}.}

\item{n_folds}{The number of folds for cross-validation.
Default is \code{5}.}

\item{subsampling_method}{The method to use for subsampling.
Options are \code{"sample"}, \code{"pseudobulk"} or \code{"meta_cells"}.}

\item{subsampling_ratio}{The percent of all samples used for \link{fit_srm}.
Default is \code{1}.}

\item{r_squared_threshold}{Threshold of \eqn{R^2} coefficient.
Default is \code{0}.}

\item{regulators}{The regulator genes for which to infer the regulatory network.}

\item{targets}{The target genes for which to infer the regulatory network.}

\item{cores}{The number of cores to use for parallelization with \link[foreach:foreach]{foreach::foreach}.
Default is \code{1}.}

\item{verbose}{Whether to print progress messages.
Default is \code{TRUE}.}

\item{...}{Parameters for other methods.}
}
\value{
A data table of regulator-target regulatory relationships.
The data table has the three columns: regulator, target, and weight.
}
\description{
inferring cell-type specific gene regulatory network
}
\examples{
data(example_matrix)
network_table_1 <- inferCSN(
  example_matrix
)

network_table_2 <- inferCSN(
  example_matrix,
  cores = 2
)

head(network_table_1)

identical(
  network_table_1,
  network_table_2
)

inferCSN(
  example_matrix,
  regulators = c("g1", "g2"),
  targets = c("g3", "g4")
)
inferCSN(
  example_matrix,
  regulators = c("g1", "g2"),
  targets = c("g3", "g0")
)

\dontrun{
data("example_ground_truth")
network_table_07 <- inferCSN(
  example_matrix,
  r_squared_threshold = 0.7
)
calculate_metrics(
  network_table_1,
  example_ground_truth,
  return_plot = TRUE
)
calculate_metrics(
  network_table_07,
  example_ground_truth,
  return_plot = TRUE
)
}
\dontrun{
data(example_matrix)
network_table <- inferCSN(example_matrix)
head(network_table)

network_table_sparse_1 <- inferCSN(
  as(example_matrix, "sparseMatrix")
)
head(network_table_sparse_1)

network_table_sparse_2 <- inferCSN(
  as(example_matrix, "sparseMatrix"),
  cores = 2
)
identical(
  network_table,
  network_table_sparse_1
)

identical(
  network_table_sparse_1,
  network_table_sparse_2
)

plot_scatter(
  data.frame(
    network_table$weight,
    network_table_sparse_1$weight
  ),
  legend_position = "none"
)

plot_weight_distribution(
  network_table
) + plot_weight_distribution(
  network_table_sparse_1
)
}
}
