% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.R
\name{plot_modelfit}
\alias{plot_modelfit}
\title{Visualization of the model fit for time series data.}
\usage{
plot_modelfit(
  x,
  view,
  event = NULL,
  n = 3,
  random = TRUE,
  cond = NULL,
  col = c(alpha(1), "red"),
  add = FALSE,
  eegAxis = FALSE,
  fill = FALSE,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  ylim = NULL,
  h0 = 0,
  v0 = NULL,
  transform = NULL,
  hide.label = FALSE,
  hide.legend = FALSE,
  print.summary = getOption("itsadug_print"),
  ...
)
}
\arguments{
\item{x}{A lm or gam object, produced by \code{\link[mgcv]{gam}} or 
\code{\link[mgcv]{bam}}, \code{\link[stats]{lm}}, \code{\link[stats]{glm}}.}

\item{view}{Text string containing the predictor or column in the data 
to be displayed on the x-axis. 
Note that variables coerced to factors in the model formula 
won't work as view variables.}

\item{event}{column name from the data 
that specifies the time series from which \code{n} are being plotted.}

\item{n}{Number of time series to plot. Default is 3. Set to -1 for plotting 
all time series (which may take a considerable time).}

\item{random}{Numeric: if set to TRUE (default), \code{n} random events are 
selected to plot. If set to FALSE, the first \code{n} events are selected 
to plot. The events could be precisely controlled with the argument 
\code{cond}.}

\item{cond}{A named list of the values to use for the other predictor terms 
(not in view) or to select specific trials or time series to plot.}

\item{col}{Two value vector specifiying the colors for the data and 
the modelfit respectively.}

\item{add}{Logical: whether or not to add the lines to an existing plot, or 
start a new plot (default).}

\item{eegAxis}{Logical: whether or not to reverse the y-axis, plotting the 
negative amplitudes upwards as traditionally is done in EEG research.
If eeg.axes is TRUE, labels for x- and y-axis are provided, when not 
provided by the user. Default value is FALSE.}

\item{fill}{Logical: whether or not to fill the area between the data and 
the fitted values with shading. Default is FALSE.}

\item{main}{Changing the main title for the plot, see also title.}

\item{xlab}{Changing the label for the x axis, 
defaults to a description of x.}

\item{ylab}{Changing the label for the y axis, 
defaults to a description of y.}

\item{ylim}{the y limits of the plot.}

\item{h0}{A vector indicating where to add solid horizontal lines for 
reference. By default no values provided.}

\item{v0}{A vector indicating where to add dotted vertical lines for 
reference. By default no values provided.}

\item{transform}{Function for transforming the fitted values. 
Default is NULL.}

\item{hide.label}{Logical: whether or not to hide the label 
(i.e., 'fitted values'). Default is FALSE.}

\item{hide.legend}{Logical: whether or not to hide the legend. 
Default is FALSE.}

\item{print.summary}{Logical: whether or not to print a summary.
Default set to the print info messages option 
(see \code{\link{infoMessages}}).}

\item{...}{other options to pass on to lines and plot, 
see \code{\link[graphics]{par}}}
}
\description{
Plots the fitted values and the data for \code{n} 
trials of time series data. For example, plots \code{n} trials 
of the same participant.
}
\section{Notes}{

This function plots the fitted effects, including intercept and other 
predictors.
}

\examples{
data(simdat)

# Create grouping predictor for time series:
simdat$Event <- interaction(simdat$Subject, simdat$Trial)

# model without random effects:
m1 <- bam(Y ~ te(Time, Trial),
    data=simdat)
plot_modelfit(m1, view='Time', event=simdat$Event)

# colorizing residuals:
plot_modelfit(m1, view='Time', event=simdat$Event, fill=TRUE)

# All trials of one subject:
\dontrun{
# this produces error:
plot_modelfit(m1, view='Time', event=simdat$Event, 
    cond=list(Subject='a01'), n=-1)
}
# instead try this:
simdat$Subj <- ifelse(simdat$Subject=='a01', TRUE, FALSE)
plot_modelfit(m1, view='Time', event=simdat$Event, 
    cond=list(Subject=simdat$Subj), n=-1)

\dontrun{
# Model with random intercepts for subjects:
m2 <- bam(Y ~ te(Time, Trial)+s(Subject, bs='re'),
    data=simdat)
# now selecting a subject works, because it is in the model:
plot_modelfit(m2, view='Time', event=simdat$Event, 
    cond=list(Subject='a01'), n=-1, ylim=c(-13,13))

# Model with random effect and interactions:
m3 <- bam(Y ~ te(Time, Trial)+s(Time, Subject, bs='fs', m=1),
    data=simdat)
plot_modelfit(m3, view='Time', event=simdat$Event, 
    cond=list(Subject='a01'), n=-1, ylim=c(-13,13))
}
}
\seealso{
Other Model evaluation: 
\code{\link{check_resid}()},
\code{\link{diagnostics}()}
}
\author{
Jacolien van Rij
}
\concept{Model evaluation}
