% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle.R
\name{sprinkle}
\alias{sprinkle}
\title{sprinkle: Disaggregates population counts at high-resolution grid cells using the grid cell's total population counts. Note that this could also be applied to more than two levels scenarios}
\usage{
sprinkle(df, rdf, rclass, toSave, rasterToCSV, output_dir, verbose = TRUE)
}
\arguments{
\item{df}{A data frame object containing sample data (often partially observed) on different demographic groups population. It contains the admin's
total populatioin count to be disaggregated as well as other key variables as defined within the 'toydata'.}

\item{rdf}{A gridded data frame object containing key information on the grid cells. Variables include the admin_id which must be identical to the one
in the admin level data. It contains GPS coordinates. i.e, longitude (lon) and Latitude (lat) of the grid cell's centroids.}

\item{rclass}{This is a user-defined names of the files to be saved in the output folder.}

\item{toSave}{Specifies the raster files to save - it has three options: set toSave="prop" to write only age and age-sex proportion files only,
or set toSave = "pop" to write age and age-sex population count files only, or set toSave = "everything" to write everything including
lower and upper bounds of 95-percent credible interval.}

\item{rasterToCSV}{This is used to declare whether the raster files should also be saved as .CSV files: set rasterToCSV = NULL to skip,
or set rasterToCSV = TRUE to write the corresponding .CSV files. Note that the length of time taken depends on the size of the files.}

\item{output_dir}{This is the directory with the name of the output folder where the
disaggregated population proportions and population totals are
automatically saved.}

\item{verbose}{Logical. If TRUE, prints progress messages. Default is TRUE.}
}
\value{
A list of data frame objects of the output files including the disaggregated population proportions and population totals
along with the corresponding measures of uncertainties (lower and upper bounds of 95-percent credible intervals) for each demographic characteristic.
In addition, a file containing the model performance/model fit evaluation metrics is also produced.
}
\description{
This function disaggregates population estimates at grid cell levels using the population counts of each grid cell.
}
\examples{
\donttest{
if (requireNamespace("INLA", quietly = TRUE)) {
 # load necessary libraries
 library(raster)
 library(terra)
 # load toy data
 data(toydata)
 # run 'cheesepop' function for admin level disaggregation
 result <- cheesepop(df = toydata$admin,output_dir = tempdir())
 rclass <- paste0("TOY_population_v1_0_age",1:12)
 # run 'sprinkle' function for grid cell disaggregation and save
 result2 <-  sprinkle(df = result$full_data, rdf = toydata$grid, rclass,
 toSave="pop",rasterToCSV = NULL,  output_dir = tempdir())
 ras2<- rast(paste0(tempdir(), "/pop_TOY_population_v1_0_age4.tif"))
 plot(ras2) # visulize raster
}
}

}
