% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate_lsmeans_wide.R
\name{summarize_lsmeans_wide}
\alias{summarize_lsmeans_wide}
\title{Layout Generating Function for LS Means Wide Table Layouts}
\usage{
summarize_lsmeans_wide(
  lyt,
  variables,
  ref_level,
  treatment_levels,
  conf_level,
  pval_sided = "2",
  include_variance = TRUE,
  include_pval = TRUE,
  formats = list(lsmean = jjcsformat_xx("xx.x"), mse = jjcsformat_xx("xx.x"), df =
    jjcsformat_xx("xx."), lsmean_diff = jjcsformat_xx("xx.x"), se =
    jjcsformat_xx("xx.xx"), ci = jjcsformat_xx("(xx.xx, xx.xx)"), pval =
    jjcsformat_pval_fct(0))
)
}
\arguments{
\item{lyt}{(\code{layout})\cr empty layout, i.e. result of \code{\link[rtables:basic_table]{rtables::basic_table()}}}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{ref_level}{(\code{string})\cr the reference level of the treatment arm variable.}

\item{treatment_levels}{(\code{character})\cr the non-reference levels of the treatment arm
variable.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{pval_sided}{(\code{string})\cr either '2' for two-sided or '1' for 1-sided with greater than
control or '-1' for 1-sided with smaller than control alternative hypothesis.}

\item{include_variance}{(\code{flag})\cr whether to include the variance statistics
(M.S. error and d.f.).}

\item{include_pval}{(\code{flag})\cr whether to include the p-value column.}

\item{formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{'auto'} setting.}
}
\value{
Modified layout.
}
\description{
Layout Generating Function for LS Means Wide Table Layouts
}
\examples{
variables <- list(
  response = "FEV1",
  covariates = c("RACE", "SEX"),
  arm = "ARMCD",
  id = "USUBJID",
  visit = "AVISIT"
)
fit <- fit_ancova(
  vars = variables,
  data = mmrm::fev_data,
  conf_level = 0.9,
  weights_emmeans = "equal"
)
anl <- broom::tidy(fit)
basic_table() |>
  summarize_lsmeans_wide(
    variables = variables,
    ref_level = fit$ref_level,
    treatment_levels = fit$treatment_levels,
    pval_sided = "2",
    conf_level = 0.8
  ) |>
  build_table(df = anl)
}
