% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{banerjee}
\alias{banerjee}
\title{Banerjee cointegration test}
\usage{
banerjee(model, signif_level = "auto")
}
\arguments{
\item{model}{The kardl obejct}

\item{signif_level}{Character or numeric. Specifies the significance level to be used in the function.
Acceptable values are "auto",  "0.25", "0.10", "0.1", "0.05", and "0.01".
If a numeric value is provided, it will be converted to a character string.
If "auto" is chosen, the function determines the significance level automatically.
Invalid values will result in an error.}
}
\value{
A list containing the results of the Banerjee cointegration test, including:
\itemize{
\item \code{type}: The type of test performed, which is "cointegration".
\item \code{case}: The case number used in the test (1, 2, 3, 4, or 5).
\item \code{statistic}: The t-statistic value calculated from the test.
\item \code{k}: The number of long-run variables in the model.
\item \code{Cont}: The conclusion of the test, indicating whether cointegration is present, inconclusive, or absent.
\item \code{BoundNum}: A numeric representation of the conclusion, where 1 indicates cointegration, 0 indicates inconclusive, and -1 indicates no cointegration.
\item \code{siglvl}: The significance level used in the test, either "auto" or one of the specified numeric levels.
\item \code{criticalValues}: A vector of critical values for the test, corresponding to the significance levels.
\item \code{parameter}: The names of the long-run variables in the model.
\item \code{FH0}: The null hypothesis of the test, which includes the long-run variables set to zero.
\item \code{Fmodel}: The linear hypothesis model used in the test.
\item \code{warnings}: Any warnings generated during the test, such as sample size concerns.
\item \code{method}: The method used for the test, which is "Narayan".
}
}
\description{
The Banerjee t test is designated for small data length. It is not recommended to be utilized for data with more than 100 observations.
}
\details{
This function conducts the Banerjee cointegration test, which is specifically designed for datasets with a limited number of observations. The test assesses whether a long-term equilibrium relationship exists between variables by examining the residuals from a regression model. The Banerjee t-test is most effective for small sample sizes and is not recommended for datasets containing more than 100 observations, as its accuracy may decrease with larger data lengths. This test is useful for analyzing cointegration in small datasets, providing insights into the stability of relationships among variables over time.
}
\examples{

kardl_model<-kardl(imf_example_data,
                   CPI~ER+PPI+asym(ER)+deterministic(covid)+trend,
                   mode=c(1,2,3,0))
A<- banerjee(kardl_model)
cat(paste0("The ECM parameter = ",A$coef,", k=",A$k," and the t statistics=",A$statistic,"."))
cat(paste0("\nWe found '",A$Cont, "' at ",A$siglvl,"."))


# Using magrittr
library(magrittr)
imf_example_data \%>\% kardl(CPI~ER+PPI+asym(ER)+deterministic(covid)+trend,
                    mode=c(1,2,3,0)) \%>\% banerjee()

# critical Values are
A$criticalValues

# Getting details of the test.
 mySummary<-summary(A)
 mySummary

# The null hypothesis :
mySummary$H0

 # Using magrittr
imf_example_data \%>\% kardl(CPI~ER+PPI+asym(ER)+deterministic(covid)+trend,
                    mode=c(1,2,3,0)) \%>\% banerjee() \%>\% summary()
}
\references{
Anindya Banerjee, Juan Dolado, Ricardo Mestre (1998) Error-correction Mechanism Tests for Cointegration in a Single-equation Framework, Journal of Time Series Analysis, Volume 19, Issue 3
}
\seealso{
\code{\link{pssf}}  \code{\link{psst}}   \code{\link{recmt}}  \code{\link{narayan}}
}
