% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simu_ise_montecarlo}
\alias{simu_ise_montecarlo}
\title{Integrated squared error via Monte Carlo}
\usage{
simu_ise_montecarlo(x, b, kernel, model, B = 10000L, delta = 0.001)
}
\arguments{
\item{x}{a cube of dimension \code{d} by \code{d} by \code{n} containing the sample matrices which define the kernel matrix estimator}

\item{b}{positive double, bandwidth parameter}

\item{model}{integer between 1 and 6 indicating the simulation scenario}

\item{B}{number of Monte Carlo replications, default to 10K}

\item{delta}{double less than 1; the integrals on \eqn{[0, \infty)} are truncated to \eqn{[\delta, 1/\delta]}.}
}
\value{
a vector of length 2 containing the mean and the standard deviation of the estimator.
}
\description{
Given a target density and a kernel estimator, evaluate the
integrated squared error by Monte Carlo integration by simulating
from uniform variates on the hypercube.
}
\keyword{internal}
