% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resid_cor.R
\name{resid_cor}
\alias{resid_cor}
\title{Residual correlations (Bentler or other types) as a tidy tibble}
\usage{
resid_cor(
  fit,
  type = c("cor.bentler", "cor", "cor.sample", "cov", "cov.sample")
)
}
\arguments{
\item{fit}{A fitted \code{lavaan} object.}

\item{type}{Character; which type of residual correlation to extract. One of
\code{c("cor.bentler", "cor", "cor.sample", "cov", "cov.sample")}. Default is
\code{"cor.bentler"}.}
}
\value{
A tibble with columns:
\itemize{
\item \code{v1}, \code{v2} – variable names in the pair
\item \code{pair} – canonical pair label \code{"v1-v2"} with alphabetical ordering via \code{pmin/pmax}
\item \code{cor} – residual correlation
\item \code{abs_cor} – absolute value of \code{cor}
\item \code{se} – standard error (if available from lavaan)
\item \code{z} – z-statistic (if available)
\item \code{group} – group label (multi-group models only)
}
}
\description{
Creates a tidy tibble of residual \strong{correlations} from a fitted \code{lavaan}
model, including standard errors and z-statistics when available. Supports
single- and multi-group models and allows selection of the correlation type
(e.g., Bentler, Pearson, or residual covariance-based).
}
\details{
Internally uses \code{lavaan::lavResiduals(type = type, se = TRUE)}.
For multi-group models, a \code{group} column is added (using
\code{lavaan::lavInspect(fit, "group.label")} when available).

\strong{Duplicate removal & stable ordering}
\itemize{
\item Residual correlations are first obtained as (group-wise) symmetric matrices.
\item Only the \emph{upper triangle without the diagonal} is kept, using a logic
equivalent to \code{mat[upper.tri(mat, diag = FALSE)]}.
\item Variable pairs are created via \code{v1 <- pmin(i, j)}, \code{v2 <- pmax(i, j)}
so that each pair appears once regardless of original order.
\item A human-readable \code{pair} label is created as \code{paste0(v1, "-", v2)}.
\item The result is sorted stably by \code{group} (if present) and \code{pair} for
reproducible outputs across sessions.
}
}
\examples{
HS.model <- '
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
'
fit <- lavaan::cfa(HS.model, data = lavaan::HolzingerSwineford1939)
resid_cor(fit)
resid_cor(fit, type = "cor")  # standard residual correlations

# Multi-group example (group by school)
fit_mg <- lavaan::cfa(
  HS.model,
  data  = lavaan::HolzingerSwineford1939,
  group = "school"
)
rc <- resid_cor(fit_mg, type = "cor.bentler")
head(rc)

}
\seealso{
\code{\link{resid_corrplot}}, \code{\link{hopper_plot}}, \code{\link{resid_qq}}
}
