% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lav_fdr.R
\name{lav_fdr}
\alias{lav_fdr}
\alias{print.lav_fdr}
\alias{summary.lav_fdr}
\title{False Discovery Rate (FDR) Correction for 'lavaan' parameter p-values}
\usage{
lav_fdr(
  fit,
  ops = c("reg", "load", "var.cov"),
  family = c("by_group", "selected"),
  method = "BY",
  alpha = 0.05,
  standardized = c("std.all", "std.lv", "std.nox", "none")
)

\method{print}{lav_fdr}(x, ...)

\method{summary}{lav_fdr}(object, ...)
}
\arguments{
\item{fit}{A fitted \code{lavaan} object.}

\item{ops}{Character. One of \code{"reg"} (regressions), \code{"load"} (factor loadings),
or \code{"var.cov"} (variances/covariances/residual variances). Default is \code{"reg"}.}

\item{family}{Character. If \code{"selected"}, FDR is applied across all selected
parameters jointly. If \code{"by_group"}, FDR is applied separately within each group.
Default is \code{"by_group"}.}

\item{method}{Character method passed to \code{stats::p.adjust} (default \code{"BY"}).}

\item{alpha}{Numeric significance threshold for adjusted p-values (default 0.05).}

\item{standardized}{Which standardized column to include, or \code{"none"}.}

\item{x}{A 'lav_fdr' object.}

\item{...}{Passed to \code{print.lav_fdr()}.}

\item{object}{A 'lav_fdr' object.}
}
\value{
A list with:
\itemize{
  \item \code{fdr_table}: data.frame with raw and FDR-adjusted p-values.
  \item \code{settings}: list of settings used.
  \item \code{group_var}: group variable name (or \code{NULL}).
  \item \code{group_labels}: group labels if available.
  \item \code{call}: matched call.
}
The returned object has class \code{"lav_fdr"}.
}
\description{
Apply a false discovery rate correction (Benjamini-Yekutieli by default) to
the p-values of selected parameters from a fitted \code{lavaan} object.
}
\details{
Useful when a SEM includes many structural paths (or many other parameters 
of substantive interest) and there is the need to control the expected 
proportion of false positives among the parameters declared 'statistically 
significant'.
 
With many simultaneous tests, using \code{p < .05} for each parameter 
inflates the expected number of false positives (about \code{m * .05} under 
all true null hypotheses, where \code{m} is the number of tested parameters).
Benjamini-Yekutieli (BY) controls the False Discovery Rate (FDR) under 
arbitrary dependence structures, which is suitable for SEMs where structural 
paths are inherently dependent through shared latent variables, covariance 
matrices, and model constraints.
}
\examples{
\dontshow{if (requireNamespace("lavaan", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library("lavaan")
model <- "
ind60 =~ x1 + x2 + x3
dem60 =~ y1 + y2 + y3 + y4
dem65 =~ y5 + y6 + y7 + y8
dem60 ~ ind60
dem65 ~ ind60 + dem60
y1 ~~ y5
y2 ~~ y6
"
fit <- lavaan::sem(
model = model, 
data = lavaan::PoliticalDemocracy,
std.lv = TRUE, 
estimator = "MLR", 
meanstructure = TRUE)
lav_fdr(fit = fit)
\dontshow{\}) # examplesIf}
}
