% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixcreation.R
\name{rleslie}
\alias{rleslie}
\title{Create Raw Leslie (Age-based) Matrix Projection Model}
\usage{
rleslie(
  data,
  start_age = NA,
  last_age = NA,
  continue = TRUE,
  fecage_min = NA,
  fecage_max = NA,
  alive = c("alive3", "alive2", "alive1"),
  repst = c("repstatus3", "repstatus2", "repstatus1"),
  fec = c("feca3", "feca2", "feca1"),
  agecol = "obsage",
  year = "all",
  supplement = NULL,
  pop = NULL,
  patch = NULL,
  yearcol = NULL,
  popcol = NULL,
  patchcol = NULL,
  indivcol = NULL,
  censor = FALSE,
  censorcol = NULL,
  censorkeep = 0,
  fectime = 2,
  fecmod = 1,
  prebreeding = TRUE,
  reduce = FALSE,
  simple = FALSE,
  err_check = FALSE,
  initial_nan = FALSE,
  sparse_output = FALSE
)
}
\arguments{
\item{data}{A vertical demographic data frame, with variables corresponding 
to the naming conventions in functions \code{\link{verticalize3}()} and
\code{\link{historicalize3}()}. Alternatively, a list of bootstrapped data of
class \code{hfv_list}.}

\item{start_age}{The age from which to start the matrix. Defaults to
\code{NA}, age \code{1} is used if \code{prebreeding = TRUE}, and age
\code{0} is used if \code{prebreeding = FALSE}.}

\item{last_age}{The final age to use in the matrix. Defaults to \code{NA}, in
which case the highest age in the dataset is used.}

\item{continue}{A logical value designating whether to allow continued
survival of individuals past the final age noted in the stageframe, using the 
demographic characteristics of the final age. Defaults to \code{TRUE}.}

\item{fecage_min}{The minimum age at which reproduction is possible. Defaults
to \code{NA}, which is interpreted to mean that fecundity should be assessed
starting in the minimum age observed in the dataset.}

\item{fecage_max}{The maximum age at which reproduction is possible. Defaults
to \code{NA}, which is interpreted to mean that fecundity should be assessed
until the final observed age.}

\item{alive}{A vector of names of binomial variables corresponding to status
as alive (\code{1}) or dead (\code{0}) in occasions \emph{t}+1 ans \emph{t},
respectively.}

\item{repst}{A vector of names of variables coding reproductive status in
occasions \emph{t}+1 and \emph{t}, respectively. Defaults to 
\code{c("repstatus3", "repstatus2")}.}

\item{fec}{A vector of names of variables coding fecundity in occasions
\emph{t}+1 and \emph{t}, respectively. Defaults to \code{c("feca3", "feca2")}.}

\item{agecol}{The name or column number of the variable coding for age in
\code{data}. Defaults to \code{"obsage"}.}

\item{year}{A variable corresponding to observation occasion, or a set
of such values, given in values associated with the \code{year} term used in
vital rate model development. Can also equal \code{"all"}, in which case
matrices will be estimated for all occasion times. Defaults to \code{"all"}.}

\item{supplement}{An optional data frame of class \code{lefkoSD} that
provides supplemental data that should be incorporated into the MPM. Three
kinds of data may be integrated this way: transitions to be estimated via the
use of proxy transitions, transition overwrites from the literature or
supplemental studies, and transition multipliers for survival and fecundity.
This data frame should be produced using the \code{\link{supplemental}()}
function.}

\item{pop}{A variable designating which populations will have matrices
estimated. Should be set to specific population names, or to \code{"all"} if
all populations should have matrices estimated.}

\item{patch}{A variable designating which patches or subpopulations will have
matrices estimated. Should be set to specific patch names, or to \code{"all"}
if matrices should be estimated for all patches. Defaults to \code{"all"}.}

\item{yearcol}{The variable name or column number corresponding to occasion 
\emph{t} in the dataset.}

\item{popcol}{The variable name or column number corresponding to the
identity of the population.}

\item{patchcol}{The variable name or column number corresponding to patch in
the dataset.}

\item{indivcol}{The variable name or column number coding individual
identity.}

\item{censor}{If \code{TRUE}, then data will be removed according to the
variable set in \code{censorcol}, such that only data with censor values
equal to \code{censorkeep} will remain. Defaults to \code{FALSE}.}

\item{censorcol}{The variable name or column number denoting the censor
status. Only needed if \code{censor = TRUE}.}

\item{censorkeep}{The value of the censor variable denoting data elements to
keep. Defaults to \code{0}.}

\item{fectime}{An integer indicating whether to estimate fecundity using
the variable given for \code{fec} in time \emph{t} (\code{2}) or time
\emph{t}+1 (\code{3}).}

\item{fecmod}{A scalar multiplier for fecundity. Defaults to \code{1.0}.}

\item{prebreeding}{A logical value indicating whether the life history model
is a pre-breeding model. Defaults to \code{TRUE}.}

\item{reduce}{A logical value denoting whether to remove ages associated with
only zero transitions. These are removed only if the respective row and
column sums in ALL matrices estimated equal 0. Defaults to \code{FALSE}, and
should generally not be used in age-based MPMs.}

\item{simple}{A logical value indicating whether to produce \code{A},
\code{U}, and \code{F} matrices, or only the latter two. Defaults to
\code{FALSE}, in which case all three are output.}

\item{err_check}{A logical value indicating whether to append extra
information used in matrix calculation within the output list. Defaults to
\code{FALSE}.}

\item{initial_nan}{A single logical value indicating whether to initialize
matrices was all elements set to \code{NaN}. Defaults to \code{FALSE}. Cannot
be used with sparse matrices.}

\item{sparse_output}{A logical value indicating whether to output matrices
in sparse format. Defaults to \code{FALSE}, in which case all matrices are
output in standard matrix format.}
}
\value{
If the user inputs a standard \code{hfv_data} object in argument
\code{data}, then this function will return an object of class
\code{lefkoMat}. If the user inputs an object of class \code{hfv_list} in
argument \code{data}, then the output will be an object of class
\code{lefkoMatList}, in which each element is an object of class
\code{lefkoMat}.

A \code{lefkoMat} object is a list that holds one full  matrix projection
model and all of its metadata. The structure has the following elements:

\item{A}{A list of full projection matrices in order of sorted populations,
patches, and occasions. All matrices output in the \code{matrix} class, or in
the \code{dgCMatrix} class from the \code{Matrix} package if sparse.}
\item{U}{A list of survival transition matrices sorted as in \code{A}. All 
matrices output in the \code{matrix} class, or in the \code{dgCMatrix} class
from the \code{Matrix} package if sparse.}
\item{F}{A list of fecundity matrices sorted as in \code{A}. All matrices 
output in the \code{matrix} class, or in the \code{dgCMatrix} class from the
\code{Matrix} package if sparse.}
\item{hstages}{A data frame matrix showing the pairing of ahistorical stages
used to create historical stage pairs. Set to NA for ahistorical matrices.}
\item{agestages}{A data frame showing age-stage pairs. In this function, it
is set to NA. Only used in output to function \code{aflefko2}().}
\item{ahstages}{A data frame detailing the characteristics of associated
ahistorical stages, in the form of a modified stageframe that includes
status as an entry stage through reproduction.}
\item{labels}{A data frame giving the population, patch, and year of each 
matrix in order.}
\item{dataqc}{A vector showing the numbers of individuals and rows in the
vertical dataset used as input.}
\item{matrixqc}{A short vector describing the number of non-zero elements in
\code{U} and \code{F} matrices, and the number of annual matrices.}
\item{modelqc}{This is the \code{qc} portion of the \code{modelsuite} input
in function-based MPMs. Empty in this function.}
}
\description{
Function \code{rleslie()} returns raw Leslie MPMs, including the
associated component transition and fecundity matrices, a data frame
describing the ages used, and a data frame describing the population, patch,
and occasion time associated with each matrix.
}
\section{Notes}{

In order to accomodate survival to time \emph{t}+1 in the final year of a
study, the maximum age assessed if no input \code{last_age} is provided is
one time step past the final described age.

Users may at times wish to estimate MPMs using a dataset incorporating
multiple patches or subpopulations. Should the aim of analysis be a general
MPM that does not distinguish these patches or subpopulations, the
\code{patchcol} variable should be left to \code{NA}, which is the default.
Otherwise the variable identifying patch needs to be named.

Input options including multiple variable names must be entered in the order
of variables in occasion \emph{t}+1 and \emph{t}. Rearranging the order WILL
lead to erroneous calculations, and may lead to fatal errors.
}

\examples{
data(cypdata)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  age_offset = 3, NAas0 = TRUE, NRasRep = TRUE)

cyp_rl <- rleslie(data = cypraw_v1, start_age = 0, last_age = 4,
  continue = TRUE, fecage_min = 3, year = "all", pop = NA, patch = "all",
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

}
\seealso{
\code{\link{mpm_create}()}

\code{\link{flefko3}()}

\code{\link{flefko2}()}

\code{\link{aflefko2}()}

\code{\link{arlefko2}()}

\code{\link{fleslie}()}

\code{\link{rlefko3}()}

\code{\link{rlefko2}()}
}
