% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-fisherian.R
\name{relative_likelihood}
\alias{relative_likelihood}
\alias{relative_likelihood.fisher_mle}
\title{Relative Likelihood}
\usage{
relative_likelihood(x, ...)

\method{relative_likelihood}{fisher_mle}(x, theta, data, model, ...)
}
\arguments{
\item{x}{A fisher_mle object}

\item{...}{Additional arguments passed to loglik}

\item{theta}{Parameter value(s) to evaluate}

\item{data}{Data frame used for likelihood computation}

\item{model}{The likelihood model used for fitting}
}
\value{
Relative likelihood value(s): L(theta)/L(theta_hat)
}
\description{
Computes the relative likelihood (likelihood ratio) for theta:
R(theta) = L(theta) / L(theta_hat) = exp(S(theta))
}
\details{
The relative likelihood is always between 0 and 1, with maximum 1 at the MLE.
Common cutoff values:
\itemize{
\item R >= 0.15 (k=8): roughly equivalent to 95\% confidence
\item R >= 0.10 (k=10): more conservative
\item R >= 0.05 (k=20): very conservative
}
}
