% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_model_manager.R
\name{register_custom_model}
\alias{register_custom_model}
\title{Register a custom model for a provider}
\usage{
register_custom_model(model_name, provider_name, model_config = list())
}
\arguments{
\item{model_name}{Unique name for the custom model}

\item{provider_name}{Name of the provider this model belongs to}

\item{model_config}{List of configuration parameters for the model (e.g., temperature, max_tokens)}
}
\value{
Invisible TRUE on success
}
\description{
Register a custom model for a provider
}
\examples{
\dontrun{
register_custom_model(
  model_name = "my_model",
  provider_name = "my_provider",
  model_config = list(
    temperature = 0.7,
    max_tokens = 2000
  )
)
}
}
