% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicalSystemModels.R
\name{fnmodelODE}
\alias{fnmodelODE}
\alias{fnmodelDx}
\alias{fnmodelDtheta}
\title{The FitzHugh-Nagumo (FN) equations}
\usage{
fnmodelODE(theta, x, tvec)

fnmodelDx(theta, x, tvec)

fnmodelDtheta(theta, x, tvec)
}
\arguments{
\item{theta}{vector of parameters.}

\item{x}{matrix of system states (one per column) at the time points in \code{tvec}.}

\item{tvec}{vector of time points}
}
\value{
\code{fnmodelODE} returns an array with the values of the derivatives \eqn{\dot{X}}.

\code{fnmodelDx} returns a 3-D array with the values of the gradients with respect to \eqn{X}.

\code{fnmodelDtheta} returns a 3-D array with the values of the gradients with respect to \eqn{\theta}.
}
\description{
The classic FN equations model the spike potentials of neurons, where system components \eqn{X = (V,R)} represent the voltage and recovery variables, respectively.

\eqn{V} and \eqn{R} are governed by the following differential equations:

\deqn{ \frac{dV}{dt} = c(V-\frac{V^3}{3}+R) }
\deqn{ \frac{dR}{dt} = -\frac{1}{c}(V-a+bR) }

where \eqn{\theta = (a,b,c)} are system parameters.
}
\examples{
theta <- c(0.2, 0.2, 3)
x <- matrix(1:10, nrow = 5, ncol = 2)
tvec <- 1:5

fnmodelODE(theta, x, tvec)

}
\references{
FitzHugh, R (1961). Impulses and Physiological States in Theoretical Models of Nerve Membrane. \emph{Biophysical Journal}, 1(6), 445–466.
}
