% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboard_functions.R
\name{launch_dashboard}
\alias{launch_dashboard}
\title{Launch Interactive Manureshed Dashboard}
\usage{
launch_dashboard(port = NULL, launch.browser = TRUE)
}
\arguments{
\item{port}{Integer. Port number for the Shiny server (default: random available port)}

\item{launch.browser}{Logical. Open browser automatically? (default: TRUE)}
}
\value{
NULL (invisibly). Launches the Shiny application.
}
\description{
Opens an interactive Shiny dashboard for exploring nutrient balance data
without writing R code. Users can select analysis parameters, view interactive
maps, explore statistics, and download results.
}
\details{
This function launches an interactive dashboard with the following features:
\itemize{
\item Select analysis parameters (year, scale, nutrients, WWTP inclusion)
\item View interactive maps of nutrient classifications
\item Explore summary statistics and distributions
\item Browse results in interactive data tables
\item Download results as CSV files
\item Generate and download PDF reports
}

The dashboard requires several suggested packages. If not installed, run:
\code{install.packages(c("shiny", "shinydashboard", "leaflet", "plotly", "DT"))}
}
\examples{
\dontrun{
# Launch the dashboard (requires suggested packages)
launch_dashboard()

# Launch on specific port
launch_dashboard(port = 3838)
}
}
