% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-methods-score.R
\name{score}
\alias{score}
\title{Posterior draws of respondent proficiency}
\usage{
score(
  x,
  newdata = NULL,
  missing = NA,
  identifier = NULL,
  summary = TRUE,
  probs = c(0.025, 0.975),
  force = FALSE
)
}
\arguments{
\item{x}{An estimated model (e.g., from \code{\link[=dcm_estimate]{dcm_estimate()}}.}

\item{newdata}{Optional new data. If not provided, the data used to estimate
the model is scored. If provided, \code{newdata} should be a data frame with 1
row per respondent and 1 column per item. All items that appear in
\code{newdata} should appear in the data used to estimate \code{x}.}

\item{missing}{An \code{R} expression specifying how missing data in \code{data} is
coded (e.g., \code{NA}, \code{"."}, \code{-99}, etc.). The default is \code{NA}.}

\item{identifier}{Optional. Variable name of a column in \code{newdata} that
contains respondent identifiers. \code{NULL} (the default) indicates that no
identifiers are present in the data, and row numbers will be used as
identifiers. If \code{newdata} is not specified and the data used to estimate
the model is scored, the \code{resp_id} is taken from the original data.}

\item{summary}{Should summary statistics be returned instead of the raw
posterior draws? Only relevant if the model was estimated with a method
that results in posterior distributions (e.g., "mcmc", "variational").
Default is \code{FALSE}.}

\item{probs}{The percentiles to be computed by the \code{\link[stats:quantile]{stats::quantile()}}
function. Only relevant if the model was estimated with a method that
results in posterior distributions (e.g., "mcmc", "variational"). Only used
if \code{summary} is \code{TRUE}.}

\item{force}{If respondent estimates have already been added to the model
object with \code{\link[=add_respondent_estimates]{add_respondent_estimates()}}, should they be recalculated.
Default is \code{FALSE}.}
}
\value{
A list with two elements: \code{class_probabilities} and
\code{attribute_probabilities}.

If summary is \code{FALSE}, each element is a tibble with one row per
respondent. The columns include the respondent identifier, and one column
of probabilities for each of the possible classes or attributes (as
\code{\link[posterior:rvar]{posterior::rvar()}} objects).

If summary is \code{TRUE}, each element is a tibble with one row per respondent
and class or attribute. The columns include the respondent identifier,
\code{class} or \code{attribute}, \code{mean}, and one column for every value specified in
\code{probs}.
}
\description{
Calculate posterior draws of respondent proficiency. Optionally retain all
posterior draws or return only summaries of the distribution for each
respondent.
}
\examples{
\dontshow{if (measr_examples()) withAutoprint(\{ # examplesIf}
rstn_mdm_lcdm <- dcm_estimate(
  dcm_specify(dcmdata::mdm_qmatrix, identifier = "item"),
  data = dcmdata::mdm_data,
  missing = NA,
  identifier = "respondent",
  method = "optim",
  seed = 63277,
  backend = "rstan"
)

score(rstn_mdm_lcdm, summary = FALSE)
\dontshow{\}) # examplesIf}
}
