% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_exp_duration.R
\name{rtf_exp_duration}
\alias{rtf_exp_duration}
\title{Exposure duration table}
\usage{
rtf_exp_duration(
  outdata,
  source = "Source: [CDISCpilot: adam-adsl; adex]",
  col_rel_width = NULL,
  text_font_size = 9,
  orientation = "portrait",
  footnotes =
    c("Each participant is counted once on each applicable duration category row.",
    "Duration of Exposure is the time from the first dose date to the last dose date."),
  title = NULL,
  path_outdata = NULL,
  path_outtable = NULL
)
}
\arguments{
\item{outdata}{An \code{outdata} object created by \code{\link[=prepare_sl_summary]{prepare_sl_summary()}}.}

\item{source}{A character value of the data source.}

\item{col_rel_width}{Column relative width in a vector e.g. c(2,1,1) refers to 2:1:1.
Default is NULL for equal column width.}

\item{text_font_size}{Text font size.  To vary text font size by column, use
numeric vector with length of vector equal to number of columns
displayed e.g. c(9,20,40).}

\item{orientation}{Orientation in 'portrait' or 'landscape'.}

\item{footnotes}{A character vector of table footnotes.}

\item{title}{Term "analysis", "observation" and "population") for collecting title from metadata or a character vector of table titles.}

\item{path_outdata}{A character string of the outdata path.}

\item{path_outtable}{A character string of the outtable path.}
}
\value{
RTF file and source dataset for baseline characteristic table.
}
\description{
Exposure duration table
}
\examples{
meta <- meta_sl_exposure_example()

meta |>
  prepare_exp_duration(population = "apat", parameter = "expdur") |>
  format_exp_duration(display_col = c("n", "prop", "total")) |>
  rtf_exp_duration(
    source = "Source: [CDISCpilot: adam-adsl; adex]",
    path_outdata = tempfile(fileext = ".Rdata"),
    path_outtable = tempfile(fileext = ".rtf")
  )
}
