% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recurrent.marginal.R
\name{count.history}
\alias{count.history}
\alias{count.historyVar}
\title{Counts the number of previous events of two types for recurrent events processes}
\usage{
count.history(
  data,
  status = "status",
  id = "id",
  types = 1,
  names.count = "Count",
  lag = TRUE,
  multitype = FALSE,
  marks = NULL
)
}
\arguments{
\item{data}{data-frame}

\item{status}{name of status}

\item{id}{id}

\item{types}{types of the events (code) related to status (multiple values possible)}

\item{names.count}{name of Counts, for example Count1 Count2 when types=c(1,2)}

\item{lag}{if true counts previously observed, and if lag=FALSE counts up to know}

\item{multitype, }{if multitype is true then counts when status "in" types, otherwise counts for each value of type, types=c(1,2)}

\item{marks}{values related to status ("in" types), counts marks for types, only when multitype=TRUE}
}
\description{
Counts the number of previous events of two types for recurrent events processes
}
\examples{
data(hfactioncpx12)
hf <- hfactioncpx12
dtable(hf,~status)
rr <-  count.history(hf,types=1:2,id="id",status="status")
dtable(rr,~"Count*"+status,level=1)

}
\author{
Thomas Scheike
}
