% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gwget}
\alias{gwget}
\title{Downloads files from FTP server}
\usage{
gwget(url = NULL, path = NULL)
}
\arguments{
\item{url}{URL of FTP server}

\item{path}{directory path where the downloaded files are stored}
}
\value{
An array of file names that have been downloaded.
}
\description{
Downloads multiple files from FTP server
}
\details{
This function downloads files from FTP server given by 'url'. The address in
'url' can contain wildcards to download more than one file at once. Files
are downloaded to a directory given by 'path' argument.  If 'path' is
'NULL', file are downloaded into 'GROOT/downloads'.
}
\examples{
gdb.init_examples()
\donttest{
outdir <- tempdir()
gwget("ftp://hgdownload.soe.ucsc.edu/goldenPath/hg19/chromosomes/md5sum.txt", path = outdir)
}

}
\seealso{
\code{\link{gtrack.import_set}}
}
\keyword{~ftp}
