% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence.R
\name{gseq.comp}
\alias{gseq.comp}
\title{Complement DNA sequence}
\usage{
gseq.comp(seq)
}
\arguments{
\item{seq}{A character vector containing DNA sequences (using A,C,G,T). Preserves case and handles NA values.}
}
\value{
A character vector of the same length as the input, containing the complemented sequences
}
\description{
Takes a DNA sequence string and returns its complement (without reversing).
}
\examples{
gseq.comp("ACTG") # Returns "TGAC"
gseq.comp(c("ACTG", "GGCC")) # Returns c("TGAC", "CCGG")
gseq.comp(c("ACTG", NA, "GGCC")) # Returns c("TGAC", NA, "CCGG")

}
\seealso{
\code{\link{gseq.revcomp}}, \code{\link{gseq.rev}}
}
