% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-management.R
\name{gintervals.dbs}
\alias{gintervals.dbs}
\title{Returns all database paths containing an interval set}
\usage{
gintervals.dbs(intervals = NULL, dataframe = FALSE)
}
\arguments{
\item{intervals}{interval set name}

\item{dataframe}{return a data frame with columns \code{intervals} and \code{db}}
}
\value{
A named character vector of database paths. If \code{dataframe} is TRUE,
returns a data frame with columns \code{intervals} and \code{db}.
}
\description{
Returns all database paths that contain a version of an interval set.
}
\details{
When datasets are loaded, an interval set may exist in multiple locations.
This function computes on-demand and returns all such paths.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gintervals.dbs("annotations1")

}
\seealso{
\code{\link{gintervals.dataset}}, \code{\link{gintervals.ls}},
\code{\link{gdataset.ls}}
}
\keyword{~database}
\keyword{~intervals}
\keyword{~path}
