% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpt_missing_person.R
\name{cpt_missing_person}
\alias{cpt_missing_person}
\title{Missing Person-Based Conditional Probability Table}
\usage{
cpt_missing_person(
  MPs = "F",
  MPc = 1,
  eps = 0.05,
  epa = 0.05,
  epc = error_matrix_hair()
)
}
\arguments{
\item{MPs}{Character. Missing person's biological sex: "F" for female,
"M" for male. Default: "F".}

\item{MPc}{Integer (1-5). Missing person's hair color category:
1=Black, 2=Brown, 3=Blonde, 4=Red, 5=Gray/White. Default: 1.}

\item{eps}{Numeric (0-1). Error rate for sex observation. The probability
of incorrectly recording the sex. Default: 0.05.}

\item{epa}{Numeric (0-1). Error rate for age categorization. The probability
of classifying a person in the wrong age group (T0 instead of T1).
Default: 0.05.}

\item{epc}{Matrix. Hair color error/confusion matrix, typically created
with \code{\link{error_matrix_hair}}. Rows represent true colors,
columns represent observed colors. Default: \code{error_matrix_hair()}.}
}
\value{
A 4x5 numeric matrix representing conditional probabilities under H1.
Rows correspond to observed sex-age group combinations:
\itemize{
\item F-T1: Observed as Female, age within range
\item F-T0: Observed as Female, age outside range
\item M-T1: Observed as Male, age within range
\item M-T0: Observed as Male, age outside range
}
Columns correspond to observed hair colors 1-5.
Each cell contains P(Observed Sex, Observed Age, Observed Color | H1, MP characteristics).
}
\description{
Computes a conditional probability table (CPT) representing the probability
of observing evidence given the hypothesis that the unidentified person IS
the missing person. This table represents P(D|H1), accounting for potential
observation errors in sex, age, and hair color.

The function incorporates error rates (epsilon values) that model the
probability of misclassifying the true characteristics of the missing
person during observation.
}
\details{
For a female MP (MPs = "F"), the joint probabilities are:
\itemize{
\item P(F-T1) = (1 - eps) * (1 - epa): Correctly observed sex and age
\item P(F-T0) = (1 - eps) * epa: Correct sex, wrong age group
\item P(M-T1) = eps * (1 - epa): Wrong sex, correct age
\item P(M-T0) = eps * epa: Wrong sex and age
}

The hair color probabilities come from the error matrix row corresponding
to the MP's true hair color.
}
\examples{
# Default: Female MP with black hair
cpt_h1 <- cpt_missing_person()
print(cpt_h1)

# Male MP with brown hair, higher error rates
cpt_h1_male <- cpt_missing_person(
  MPs = "M",
  MPc = 2,
  eps = 0.10,
  epa = 0.10
)

# Compare H1 and H2 to compute LR
cpt_h2 <- cpt_population()
lr_matrix <- cpt_h1 / cpt_h2
print(log10(lr_matrix))
}
\references{
Marsico FL, et al. (2023). "Likelihood ratios for non-genetic evidence
in missing person cases." \emph{Forensic Science International: Genetics},
66, 102891. \doi{10.1016/j.fsigen.2023.102891}
}
\seealso{
\code{\link{cpt_population}} for the H2 conditional probability table,
\code{\link{error_matrix_hair}} for creating the color error matrix,
\code{\link{plot_cpt}} for visualization of CPTs.
}
