% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_data.R
\name{check_data}
\alias{check_data}
\title{Sanity check for input data before imputation}
\usage{
check_data(data, max_levels = round(0.5 * nrow(data)), verbose = TRUE)
}
\arguments{
\item{data}{A data frame or data table.}

\item{max_levels}{An integer specifying the maximum number of levels allowed for a factor variable. This is used to detect potential ID columns that are often non-informative for imputation. Default: 50\% of the number of rows, rounded to the nearest integer.}

\item{verbose}{Verbose setting. If \code{TRUE}, will print out warnings when data issues are found. Default: \code{TRUE}.}
}
\value{
A preliminary checked dataset
}
\description{
The function `check_data()` serves the purpose of performing a preliminary check and fix some evident issues. However, the function cannot resolve all data quality-related problems.
}
\examples{
bad_data <- data.frame(Amount = c(Inf, 10, 201.5), Type = factor(c("NaN", "B", "A")))
checked_data <- check_data(data = bad_data, verbose = TRUE)
}
