% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{create_table_tbl}
\alias{create_table_tbl}
\title{Overwrite or Append a Local Tibble to a Database Table}
\usage{
create_table_tbl(
  .data,
  .con,
  database_name,
  schema_name,
  table_name,
  write_type = "overwrite"
)
}
\arguments{
\item{.data}{A tibble or data frame to be written to the database.}

\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{database_name}{Name of the database to create/use. If missing,
the current database of the connection will be used.}

\item{schema_name}{Name of the schema to create/use. If missing,
the current schema of the connection will be used.}

\item{table_name}{Name of the table to create or append to.}

\item{write_type}{Write strategy: either \code{"overwrite"} (drop/create)
or \code{"append"} (insert rows). Defaults to \code{"overwrite"}.}
}
\value{
Invisibly returns \code{NULL}.
Side effect: writes the tibble to the specified database table.
}
\description{
Takes an in-memory tibble (or data frame) and writes it to a database table
using a \code{DBI} connection. The function supports both \strong{overwrite} and
\strong{append} modes, automatically creates the target database and schema if
they do not exist, and adds audit fields (\code{upload_date}, \code{upload_time}) to
the written table.
}
\details{
\itemize{
\item If the connection is a MotherDuck connection (detected by
\code{validate_md_connection_status()}), the function ensures the
database is created and switches to it before creating the schema.
\item Two audit columns are added to the data before writing:
\code{upload_date} (date of run) and \code{upload_time} (time and timezone of run).
\item Uses \code{DBI::Id()} to explicitly target the database/schema/table.
\item \code{write_type = "overwrite"} will drop and recreate the table.
\item \code{write_type = "append"} will insert rows into an existing table.
}
}
\keyword{internal}
