% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R
\name{Popover}
\alias{Popover}
\title{Popover}
\usage{
Popover(...)
}
\arguments{
\item{...}{Props to pass to the component.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/material-ui/api/popover/}
}
\details{
\itemize{
\item open \code{bool} \cr Default is - If true, the component is shown.
\item action \code{ref} \cr Default is - A ref for imperative actions. It currently only supports updatePosition() action.
\item anchorEl \verb{HTML element| func} \cr Default is - An HTML element, PopoverVirtualElement, or a function that returns either. It's used to set the position of the popover.
\item anchorOrigin \verb{\{ horizontal: 'center'| 'left'| 'right'| number, vertical: 'bottom'| 'center'| 'top'| number \}} \cr Default is vertical: 'top', horizontal: 'left', This is the point on the anchor where the popover's anchorEl will attach to. This is not used when the anchorReference is 'anchorPosition'.Options: vertical: top, center, bottom; horizontal: left, center, right.
\item anchorPosition \verb{\{ left: number, top: number \}} \cr Default is - This is the position that may be used to set the position of the popover. The coordinates are relative to the application's client area.
\item anchorReference \code{'anchorEl'| 'anchorPosition'| 'none'} \cr Default is 'anchorEl' This determines which anchor prop to refer to when setting the position of the popover.
\item BackdropComponent \code{elementType} \cr Default is styled(Backdrop, name: 'MuiModal', slot: 'Backdrop', overridesResolver: (props, styles) = return styles.backdrop; , )( zIndex: -1, ) A backdrop component. This prop enables custom backdrop rendering.Deprecated Use slots.backdrop instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item BackdropProps \code{object} \cr Default is - Props applied to the Backdrop element.Deprecated Use slotProps.backdrop instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item children \code{node} \cr Default is - The content of the component.
\item classes \code{object} \cr Default is - Override or extend the styles applied to the component.See CSS classes API below for more details.
\item container \verb{HTML element| func} \cr Default is - An HTML element, component instance, or function that returns either. The container will passed to the Modal component.By default, it uses the body of the anchorEl's top-level document object, so it's simply document.body most of the time.
\item disableScrollLock \code{bool} \cr Default is FALSE Disable the scroll lock behavior.
\item elevation \code{integer} \cr Default is 8 The elevation of the popover.
\item marginThreshold \code{number} \cr Default is 16 Specifies how close to the edge of the window the popover can appear. If null, the popover will not be constrained by the window.
\item onClose \code{func} \cr Default is - Callback fired when the component requests to be closed. The reason parameter can optionally be used to control the response to onClose.
\item PaperProps \verb{\{ component?: element type \}} \cr Default is Props applied to the Paper element.This prop is an alias for slotProps.paper and will be overriden by it if both are used.Deprecated Use slotProps.paper instead.
\item slotProps \verb{\{ backdrop?: func| object, paper?: func| object, root?: func| object, transition?: func| object \}} \cr Default is The props used for each slot inside.
\item slots \verb{\{ backdrop?: elementType, paper?: elementType, root?: elementType, transition?: elementType \}} \cr Default is The components used for each slot inside.
\item sx \verb{Array func| object| bool | func| object} \cr Default is - The system prop that allows defining system overrides as well as additional CSS styles.See the \code{sx} page for more details.
\item transformOrigin \verb{\{ horizontal: 'center'| 'left'| 'right'| number, vertical: 'bottom'| 'center'| 'top'| number \}} \cr Default is vertical: 'top', horizontal: 'left', This is the point on the popover which will attach to the anchor's origin.Options: vertical: top, center, bottom, x(px); horizontal: left, center, right, x(px).
\item TransitionComponent \code{elementType} \cr Default is Grow The component used for the transition. Follow this guide to learn more about the requirements for this component.Deprecated use the slots.transition prop instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item transitionDuration \verb{'auto'| number| \{ appear?: number, enter?: number, exit?: number \}} \cr Default is 'auto' Set to 'auto' to automatically calculate transition time based on height.
\item TransitionProps \code{object} \cr Default is Props applied to the transition element. By default, the element is based on this Transition component.Deprecated use the slotProps.transition prop instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
}
}
