% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvgam_residcor-class.R
\name{plot.mvgam_residcor}
\alias{plot.mvgam_residcor}
\title{Plot residual correlations based on latent factors}
\usage{
\method{plot}{mvgam_residcor}(x, cluster = FALSE, ...)
}
\arguments{
\item{x}{\code{list} object of class \code{mvgam_residcor} resulting from a
call to \code{residual_cor(..., summary = TRUE)}}

\item{cluster}{Logical. Should the variables be re-arranged within the plot
to group the correlation matrix into clusters of positive and negative correlations?
Defaults to \code{FALSE}}

\item{...}{ignored}
}
\value{
A \code{ggplot} object
}
\description{
Plot residual correlation estimates from Joint Species Distribution
(\code{jsdgam}) or dynamic factor (\code{mvgam}) models
}
\details{
This function plots the significant residual correlations from a
\code{mvgam_residcor} object, whereby the posterior mean (if \code{robust = FALSE})
or posterior median (if \code{robust = TRUE}) correlations are shown
only those correlations whose credible interval does not contain zero. All other
correlations are set to zero in the returned plot
}
\seealso{
\code{\link[=jsdgam]{jsdgam()}}, \code{\link[=lv_correlations]{lv_correlations()}}, \code{\link[=residual_cor]{residual_cor()}}
}
\author{
Nicholas J Clark
}
