% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logical-track.R
\name{emr_track.logical.create}
\alias{emr_track.logical.create}
\title{Creates a logical track}
\usage{
emr_track.logical.create(track, src, values = NULL)
}
\arguments{
\item{track}{one or more names of the newly created logical tracks.}

\item{src}{name of the physical tracks for each logical \code{track}}

\item{values}{vector of selected values. When creating multiple logical tracks at once
- \code{values} should be a list of vectors (with one vector of values for each logical track).}
}
\value{
None.
}
\description{
Creates a logical track
}
\details{
This function creates a logical track based on an existing categorical track
in the global space.

Note: Both the logical track and source should be on the global db. If the logical track
would be created and afterwards the db would be loaded as non-global db the logical tracks
would **not** be visible.
}
\examples{
\donttest{
emr_track.logical.create("logical_track_example", "categorical_track", values = c(2, 3))

# multiple tracks
emr_track.logical.create(
    c("logical_track1", "logical_track2", "logical_track3"),
    rep("categorical_track", 3),
    values = list(c(2, 3), NULL, c(1, 4))
)
}

}
\keyword{~create_logical}
\keyword{~track}
