% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{shape_data}
\alias{shape_data}
\title{Shape data as input for \code{\link[=fb_select]{fb_select()}}}
\usage{
shape_data(
  data,
  age_name,
  score_name,
  family,
  max_score = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{data.frame. Sample on which to fit the distribution; contains the scores and ages.}

\item{age_name}{string. Name of the age variable.}

\item{score_name}{string. Name of the score variable.}

\item{family}{string. For example, \code{"BB"}, \code{"BCPE"}, \code{"NO"}, etc.
See \link[gamlss.dist:gamlss.family]{gamlss.dist::gamlss.family} for more information.}

\item{max_score}{numeric. Highest possible score in the norm table.
Defaults to the maximum observed score in the sample.}

\item{verbose}{logical. If \code{TRUE}, messages are printed whenever a transformation is applied.}
}
\value{
A data.frame containing the original variables and a new column \code{shaped_score},
with the response variable in the correct format for GAMLSS modeling.
}
\description{
\code{shape_data()} reshapes the response variable into the right format for the specified
distribution and removes all cases with missing data on the score or age variable.
The result is suitable for use as input to \code{\link[=fb_select]{fb_select()}}.
}
\details{
The function checks whether the response values are valid for the specified
GAMLSS distribution family. If not, transformations are applied to ensure compatibility.
Messages are printed (if \code{verbose = TRUE}) to describe each transformation.

Unexpected transformations should prompt inspection of the original data.
Note that the function does \strong{not} assess whether the chosen family is appropriate
for the data—it only ensures compatibility.

Compatible with all gamlss distributions, with the exception of distributions in the multinomial family (\link[gamlss:binom]{gamlss::.gamlss.multin.list}).
This includes user-defined distributions, such as truncated distributions.
}
\examples{
invisible(data("ids_data"))
mydata_BB <- shape_data(ids_data, age_name = "age", score_name = "y14", family = "BB")
mydata_BCPE <- shape_data(ids_data, age_name = "age", score_name = "y14", family = "BCPE")

}
\references{
\insertRef{voncken2019model}{normref}
}
\seealso{
\code{\link[=fb_select]{fb_select()}}
}
