% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.2.mod.R
\name{power.2.mod}
\alias{power.2.mod}
\title{Statistical power, sample size (and/or budget), minimum detectable moderator
effect size calculation for two-level cluster-randomized trials (CRTs)
detecting moderation effects}
\usage{
power.2.mod(
  cost.model = TRUE,
  expr = NULL,
  constraint = NULL,
  sig.level = 0.05,
  two.tailed = TRUE,
  gamma = NULL,
  power.mod = NULL,
  m = NULL,
  n = NULL,
  J = NULL,
  p = NULL,
  icc = NULL,
  r12 = NULL,
  r22 = NULL,
  r12m = NULL,
  r22m = NULL,
  q.mod = 1,
  c1 = NULL,
  c2 = NULL,
  c1t = NULL,
  c2t = NULL,
  gammalim = c(0, 5),
  powerlim = c(1e-10, 1 - 1e-10),
  Jlim = c(5.5, 1e+10),
  binary = TRUE,
  mlim = NULL,
  rounded = TRUE,
  Q = 0.5
)
}
\arguments{
\item{cost.model}{Logical; power analyses accommodating costs and budget
(e.g., required budget for desired power, power/MDES under fixed budget)
if TRUE, otherwise conventional power analyses
(e.g., required sample size, power, or MDES calculation); default value is TRUE.}

\item{expr}{Returned objects from function \code{\link{od.2.mod}}; default is NULL;
if \code{expr} is specified, parameter values of \code{icc},
\code{r12}, \code{r22}, \code{r12m}, \code{r22m},
\code{c1}, \code{c2},
\code{c1t}, \code{c2t}, \code{p}, and \code{n}
used or solved in function \code{\link{od.2.mod}} will
be passed to the current function;
only the values of \code{p} and \code{n} that specified or solved in
function \code{\link{od.2.mod}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{Specify the constrained values of \code{p} and/or \code{n}
in list format to overwrite those from \code{expr}; default value is NULL.}

\item{sig.level}{Significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{Two tailed test, the default value is TRUE.}

\item{gamma}{The standardized moderated treatment effect
(i.e., regression coefficient of the interaction
term of moderator and treatment).}

\item{power.mod}{Statistical power specified for moderation.
The default value is .80.}

\item{m}{Total budget.}

\item{n}{The level-1 sample size per level-2 unit.}

\item{J}{The total level-2 sample size.}

\item{p}{The proportion of level-2 clusters/units to be assigned to treatment.}

\item{icc}{The unconditional intraclass correlation coefficient (ICC) in population or in
each treatment condition.}

\item{r12}{The proportion of level-1 variance explained by covariates.}

\item{r22}{The proportion of level-2 variance explained by covariates.}

\item{r12m}{The proportion of outcome variance at the individual level
explained by covariates in the model with the moderator.}

\item{r22m}{The proportion of outcome variance at the cluster level
explained by covariates in the model with the moderator.}

\item{q.mod}{The number of cluster-level covariates in the model
(except the treatment indicator, moderator, and the interaction term).
The default value is 1.}

\item{c1}{The cost of sampling one level-1 unit in control condition.}

\item{c2}{The cost of sampling one level-2 unit in control condition.}

\item{c1t}{The cost of sampling one level-1 unit in treatment condition.}

\item{c2t}{The cost of sampling one level-2 unit in treatment condition.}

\item{gammalim}{The range for numerically solving the root of standardized
moderation effect (gamma). Default is c(0, 5).}

\item{powerlim}{The range for solving the root of power (\code{power}) numerically,
default value is c(1e-10, 1 - 1e-10).}

\item{Jlim}{The range for numerically solving the root of
the sample size requirement(\code{J}).}

\item{binary}{Logical; The moderator is binary if TRUE,
and continuous if FALSE. The default is TRUE.}

\item{mlim}{The range for numerically solving the root of budget (\code{m}).
The default is NULL, which mlim = Jlim times the costs for each site and
its members.}

\item{rounded}{Logical; round \code{n} and \code{p} that are from functions \code{od.2}
to integer and two decimal places, respectively if TRUE,
otherwise no rounding; default value is TRUE.}

\item{Q}{The proportion of binary moderator that coded as 1.
Default is 0.50.}

\item{power}{Statistical power.mod for a moderation effect.}
}
\value{
Required budget (and/or required level-2 sample size), statistical power,
    or MDMES depending on the specification of parameters.
    The function also returns the function name, design type,
    and parameters used in the calculation.
}
\description{
This function can calculate power, required sample size/budget
    for desired power, or minimum detectable moderation effect size (MDMES)
    under a fixed budget in two-level CRTs.
    It also can perform conventional power analyses
    (e.g., required sample size, power, and MDMES calculation).
}
\examples{
myod <- od.2.mod(icc = .2, r12 = .5, r22 = .5,
                 c1 = 10, c1t = 100, c2 = 50, c2t = 500,
                 gamma = 0.2, d = 0.2)
mypower <- power.2.mod(expr = myod, m=myod$out$m, gamma = 0.2); mypower$out
mym <- power.2.mod(expr = myod, power.mod = .80, gamma = 0.2); mym$out

}
