# OPERATORS

build_query <- function(x) {
  if (is.list(x)) {
    term <- vapply(x, FUN = build_query, FUN.VALUE = character(1))
    term <- paste(term, collapse = " AND ")
    term <- sprintf("(%s)", term)
    return(term)
  } else if (is.atomic(x) && is.vector(x)) {
    term <- paste(as.character(x), collapse = " OR ")
    term <- ifelse(length(x) == 1, term, sprintf("(%s)", term))
    return(term)
  } else {
    # TODO: error
  }
}

#' @rdname operators
#' @export
`%OR%` <- function(x, y) {
  x <- build_query(x)
  y <- build_query(y)
  sprintf("%s OR %s", x, y)
}

#' @rdname operators
#' @export
`%AND%` <- function(x, y) {
  x <- build_query(x)
  y <- build_query(y)
  sprintf("%s AND %s", x, y)
}

#' @rdname operators
#' @export
`%NOT%` <- function(x, y) {
  x <- build_query(x)
  y <- build_query(y)
  sprintf("%s NOT %s", x, y)
}

#' @rdname operators
#' @export
`%BY%` <- function(x, y) {
  z <- paste(x, collapse = " ")
  s <- ifelse(length(x) == 1, "%s~%s", "\"%s\"~%s")
  sprintf(s, z, y)
}

#' @rdname operators
#' @export
`%IN%` <- function(x, y) {
  x <- build_query(x)
  y <- build_query(y)
  sprintf("%s:%s", y, x)
}

#' @rdname operators
#' @export
`%TO%` <- function(x, y) {
  if (x == "" || length(x) == 0 || is.null(x)) x <- "\"\""
  if (y == "" || length(y) == 0 || is.null(y)) y <- "*"
  sprintf("[%s TO %s]", x, y)
}
