% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newton_raphson.R
\name{newton_raphson}
\alias{newton_raphson}
\title{Pure Newton-Raphson Optimization}
\usage{
newton_raphson(
  start,
  objective,
  gradient = NULL,
  hessian = NULL,
  lower = -Inf,
  upper = Inf,
  control = list(),
  ...
)
}
\arguments{
\item{start}{Numeric vector. Starting values for the optimization parameters.}

\item{objective}{Function. The objective function to minimize.}

\item{gradient}{Function (optional). Gradient of the objective function.}

\item{hessian}{Function (optional). Hessian matrix of the objective function.}

\item{lower}{Numeric vector. Lower bounds for box constraints.}

\item{upper}{Numeric vector. Upper bounds for box constraints.}

\item{control}{List. Control parameters including convergence flags:
\itemize{
  \item \code{use_abs_f}: Logical. Use absolute change in objective for convergence.
  \item \code{use_rel_f}: Logical. Use relative change in objective for convergence.
  \item \code{use_abs_x}: Logical. Use absolute change in parameters for convergence.
  \item \code{use_rel_x}: Logical. Use relative change in parameters for convergence.
  \item \code{use_grad}: Logical. Use gradient norm for convergence.
  \item \code{use_posdef}: Logical. Verify positive definiteness at convergence.
  \item \code{use_pred_f}: Logical. Record predicted objective decrease.
  \item \code{use_pred_f_avg}: Logical. Record average predicted decrease.
  \item \code{diff_method}: String. Method for numerical differentiation.
}}

\item{...}{Additional arguments passed to objective, gradient, and Hessian functions.}
}
\value{
A list containing optimization results and iteration metadata.
}
\description{
Implements the standard Newton-Raphson algorithm for non-linear optimization 
without Hessian modifications or ridge adjustments.
}
\details{
\code{newton_raphson} provides a classic second-order optimization approach. 

\bold{Comparison with Modified Newton:}
Unlike \code{modified_newton}, this function does not apply dynamic ridge 
adjustments (Levenberg-Marquardt style) to the Hessian. If the Hessian is 
singular or cannot be inverted via \code{solve()}, the algorithm will 
terminate. This "pure" implementation is often preferred in simulation 
studies where the behavior of the exact Newton step is of interest.

\bold{Predicted Decrease:}
This function explicitly calculates the \bold{Predicted Decrease} (\eqn{pred\_dec}), 
which is the expected reduction in the objective function value based on 
the local quadratic model: 
\deqn{m(p) = f + g^T p + \frac{1}{2} p^T H p}

\bold{Stability and Simulations:}
All return values are explicitly cast to scalars (e.g., \code{as.numeric}, 
\code{as.logical}) to ensure stability when the function is called within 
large-scale simulation loops or packaged into data frames.
}
\references{
\itemize{
   \item Nocedal, J., & Wright, S. J. (2006). \emph{Numerical Optimization}. Springer.
   \item Bollen, K. A. (1989). \emph{Structural Equations with Latent Variables}. Wiley.
}
}
