% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{predict.wbgee}
\alias{predict.wbgee}
\title{Predictions and simulations from within-between GEE models}
\usage{
\method{predict}{wbgee}(
  object,
  newdata = NULL,
  type = c("link", "response"),
  se.fit = FALSE,
  raw = FALSE,
  ...
)
}
\arguments{
\item{object}{Object of class inheriting from \code{"lm"}}

\item{newdata}{An optional data frame in which to look for variables with
    which to predict.  If omitted, the fitted values are used.}

\item{type}{Type of prediction (response or model term).  Can be abbreviated.}

\item{se.fit}{A switch indicating if standard errors are required.}

\item{raw}{Is \code{newdata} a \code{geeglm} model frame or \code{panel_data}? TRUE
indicates a \code{geeglm}-style newdata, with all of the extra columns
created by \code{wbgee}.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
These methods facilitate fairly straightforward predictions
from \code{wbgee} models.
}
\examples{
if (requireNamespace("geepack")) {
  data("WageData")
  wages <- panel_data(WageData, id = id, wave = t)
  model <- wbgee(lwage ~ lag(union) + wks, data = wages)
  # By default, assumes you're using the processed data for newdata
  predict(model)
}
}
