% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{predict.wbm}
\alias{predict.wbm}
\alias{simulate.wbm}
\title{Predictions and simulations from within-between models}
\usage{
\method{predict}{wbm}(
  object,
  newdata = NULL,
  se.fit = FALSE,
  raw = FALSE,
  use.re.var = FALSE,
  re.form = NULL,
  type = c("link", "response"),
  allow.new.levels = TRUE,
  na.action = na.pass,
  ...
)

\method{simulate}{wbm}(
  object,
  nsim = 1,
  seed = NULL,
  use.u = FALSE,
  newdata = NULL,
  raw = FALSE,
  newparams = NULL,
  re.form = NA,
  type = c("link", "response"),
  allow.new.levels = FALSE,
  na.action = na.pass,
  ...
)
}
\arguments{
\item{object}{a fitted model object}

\item{newdata}{data frame for which to evaluate
    predictions.}

\item{se.fit}{Include standard errors with the predictions? Note that
these standard errors by default include only fixed effects variance.
See details for more info. Default is FALSE.}

\item{raw}{Is \code{newdata} a \code{merMod} model frame or \code{panel_data}? TRUE
indicates a \code{merMod}-style newdata, with all of the extra columns
created by \code{wbm}.}

\item{use.re.var}{If \code{se.fit} is TRUE, include random effects variance in
standard errors? Default is FALSE.}

\item{re.form}{(formula, \code{NULL}, or \code{NA}) specify which random effects to condition on when predicting.  If \code{NULL},
    include all random effects; if \code{NA} or \code{~0},
    include no random effects.}

\item{type}{character string - either \code{"link"}, the default, or
    \code{"response"} indicating the type of prediction object returned.}

\item{allow.new.levels}{logical if new levels (or NA values) in
    \code{newdata} are allowed. If FALSE (default), such new values in
    \code{newdata} will trigger an error; if TRUE, then the prediction
    will use the unconditional (population-level) values for data with
    previously unobserved levels (or NAs).}

\item{na.action}{\code{\link{function}} determining what should be done
    with missing values for fixed effects in \code{newdata}.
    The default is to predict \code{NA}: see \code{\link{na.pass}}.}

\item{...}{When \code{boot} and \code{se.fit} are TRUE, any additional arguments are
passed to \code{lme4::bootMer()}.}

\item{nsim}{positive integer scalar - the number of responses to simulate.}

\item{seed}{an optional seed to be used in \code{\link{set.seed}}
    immediately before the simulation so as to generate a reproducible sample.}

\item{use.u}{(logical) if \code{TRUE}, generate a simulation
    conditional on the current random-effects estimates; if \code{FALSE}
    generate new Normally distributed random-effects values. (Redundant
    with \code{re.form}, which is preferred: \code{TRUE} corresponds to
    \code{re.form = NULL} (condition on all random effects), while
    \code{FALSE} corresponds to \code{re.form = ~0} (condition on none
    of the random effects).)}

\item{newparams}{new parameters to use in evaluating predictions,
    specified as in the \code{start} parameter for \code{\link[lme4]{lmer}} or
    \code{\link[lme4]{glmer}} -- a list with components \code{theta} and
    \code{beta} and (for LMMs or GLMMs that estimate a scale parameter)
    \code{sigma}}
}
\description{
These methods facilitate fairly straightforward predictions
and simulations from \code{wbm} models.
}
\details{
For \code{wbm} models, \code{predict()} operates in two main modes:
\itemize{
\item \code{raw = FALSE} (the default): \code{newdata} is treated as panel-style data. If it
is not already a \code{\link[=panel_data]{panel_data()}} object, it is converted
using the \code{id} and \code{wave} variables from the original model. The within /
between decomposition and any detrending are recomputed for \code{newdata}
before passing the resulting design matrix to \code{lme4} via
\code{\link[jtools:predict_merMod]{jtools::predict_merMod()}} on the underlying \code{merMod} object.
\item \code{raw = TRUE}: \code{newdata} is expected to already be on the "model matrix"
scale used by the fitted \code{wbm} object, including internal columns such as
\code{imean(...)} and any processed interaction terms. In this case, panelr
does not recompute within / between pieces and simply forwards \code{newdata}
to \code{\link[jtools:predict_merMod]{jtools::predict_merMod()}}.
}

When \code{newdata} is not \code{panel_data} and \code{raw = FALSE}, \code{predict.wbm()} will
synthesize missing \code{id} or \code{wave} columns when possible in order to build a
valid panel structure (for example, when \code{re.form = ~0}). Informational
messages are emitted in these cases. For most within between use cases it is
safer and more transparent to explicitly create a \code{panel_data} object with
the desired \code{id} and \code{wave} variables before calling \code{predict()}.

For models fit with \code{model = "within"}, predictions from \code{predict.wbm()}
reflect the within specification, which is parameterized using centered
within unit effects and any specified between components. As a consequence,
\code{predict(wbm_obj)} for a within model is not in general identical to
\code{predict(to_merMod(wbm_obj))} on the internal \code{lmerMod} / \code{glmerMod} object,
even when using the same \code{re.form} argument, because the fixed effect
structure differs. This is by design: \code{predict.wbm()} always works on the
within between representation defined by the original \code{wbm()} call, while
\code{to_merMod()} exposes the underlying mixed model fit directly.
}
\examples{
data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
model <- wbm(lwage ~ lag(union) + wks, data = wages)
# By default, assumes you're using the processed data for newdata
predict(model)
}
