% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{getWhatMeasured}
\alias{getWhatMeasured}
\alias{what_measured}
\alias{getWhatMeasured.default}
\alias{getWhatMeasured.generic_spct}
\alias{getWhatMeasured.summary_generic_spct}
\alias{getWhatMeasured.data.frame}
\alias{getWhatMeasured.generic_mspct}
\title{Get the \code{"what.measured"} attribute}
\usage{
getWhatMeasured(x, ...)

what_measured(x, ...)

\method{getWhatMeasured}{default}(x, ...)

\method{getWhatMeasured}{generic_spct}(x, ..., simplify = FALSE)

\method{getWhatMeasured}{summary_generic_spct}(x, ..., simplify = FALSE)

\method{getWhatMeasured}{data.frame}(x, ..., simplify = FALSE)

\method{getWhatMeasured}{generic_mspct}(x, ..., idx = "spct.idx", simplify = FALSE)
}
\arguments{
\item{x}{an R object.}

\item{...}{Allows use of additional arguments in methods for other classes.}

\item{simplify}{logical If all members share the same attribute value return
one copy instead of a \code{data.frame}.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}
}
\value{
\code{character} vector An object containing a description of the
  data. If \code{x} does not belong to a supported class \code{NA} is
  returned.
}
\description{
Method to read the \code{"what.measured"} attribute of an R object.
}
\section{Methods (by class)}{
\itemize{
\item \code{getWhatMeasured(default)}: default

\item \code{getWhatMeasured(generic_spct)}: generic_spct

\item \code{getWhatMeasured(summary_generic_spct)}: summary_generic_spct

\item \code{getWhatMeasured(data.frame)}: data.frame

\item \code{getWhatMeasured(generic_mspct)}: generic_mspct

}}
\note{
The method for collections of spectra returns the
  a \code{data.frame} with a column of character strings.
}
\examples{
my.spct <- sun.spct
what_measured(my.spct)
what_measured(my.spct) <- "Sun"
what_measured(my.spct)
what_measured(my.spct) <- NULL
what_measured(my.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
