% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-var-labels.R
\name{make_var_labels}
\alias{make_var_labels}
\alias{make_var_labels.default}
\alias{make_var_labels.source_spct}
\alias{make_var_labels.response_spct}
\alias{make_var_labels.filter_spct}
\alias{make_var_labels.reflector_spct}
\alias{make_var_labels.object_spct}
\alias{make_var_labels.solute_spct}
\alias{make_var_labels.chroma_spct}
\alias{make_var_labels.calibration_spct}
\alias{make_var_labels.raw_spct}
\alias{make_var_labels.cps_spct}
\title{Column or variable labels}
\usage{
make_var_labels(x, ...)

\method{make_var_labels}{default}(x, ...)

\method{make_var_labels}{source_spct}(x, ...)

\method{make_var_labels}{response_spct}(x, ...)

\method{make_var_labels}{filter_spct}(x, ...)

\method{make_var_labels}{reflector_spct}(x, ...)

\method{make_var_labels}{object_spct}(x, ...)

\method{make_var_labels}{solute_spct}(x, ...)

\method{make_var_labels}{chroma_spct}(x, ...)

\method{make_var_labels}{calibration_spct}(x, ...)

\method{make_var_labels}{raw_spct}(x, ...)

\method{make_var_labels}{cps_spct}(x, ...)
}
\arguments{
\item{x}{An object of a class derived from \code{generic_spct}.}

\item{...}{Currently ignored.}
}
\value{
A named list of character strings with one member for each recognized
  column in \code{x}. This list can be used to set variable labels with
  methods from package 'labelled'. However, package 'photobiology' does not
  natively support variable labels stored in attribute \code{label}.
}
\description{
Create a named list of character strings describing the variables contained
in a spectrum object.
}
\details{
Objects of classes derived from \code{generic_spct} are used to
  store different types of spectral data. The data stored in some of the
  classes needs to be interpreted differently depending on how they were
  measured or are expressed and this information is stored in attributes of
  the objects. In other cases, even if consistent across different objects,
  the units of expression may not be obvious to users. The names of the
  variables are concise, thus using variable labels makes it possible to
  make these features visible when exploring the data. The methods provided
  do not add the labels, only supply the character strings. Variable labels
  are implemented in packages 'labelled' by setting the \code{label}
  attribute in each variable (= column) of a data frame or tibble. This is
  compatible with the approach used by package 'haven'.
}
\section{Methods (by class)}{
\itemize{
\item \code{make_var_labels(default)}: 

\item \code{make_var_labels(source_spct)}: 

\item \code{make_var_labels(response_spct)}: 

\item \code{make_var_labels(filter_spct)}: 

\item \code{make_var_labels(reflector_spct)}: 

\item \code{make_var_labels(object_spct)}: 

\item \code{make_var_labels(solute_spct)}: 

\item \code{make_var_labels(chroma_spct)}: 

\item \code{make_var_labels(calibration_spct)}: 

\item \code{make_var_labels(raw_spct)}: 

\item \code{make_var_labels(cps_spct)}: 

}}
\note{
These methods are still under development and the text of the labels
  may change. Not all classes derived from \code{generic_spct} are yet
  supported.
}
\examples{
make_var_labels(sun.spct)
# str() prints more compactly than print()
str(make_var_labels(sun.spct))
str(make_var_labels(normalize(sun.spct)))
str(make_var_labels(fscale(sun.spct)))

str(make_var_labels(sun_daily.spct))

str(make_var_labels(polyester.spct))
str(make_var_labels(normalize(polyester.spct)))
str(make_var_labels(fscale(polyester.spct)))

str(make_var_labels(white_led.cps_spct))
str(make_var_labels(white_led.raw_spct))

}
