% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_bin_auto.R
\docType{data}
\name{stat_bin_auto}
\alias{stat_bin_auto}
\alias{StatBinAuto}
\title{Calculate bins using scale breaks}
\usage{
stat_bin_auto(
  mapping = NULL,
  data = NULL,
  geom = "bar",
  position = "stack",
  ...,
  breaks = "all",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  pad = FALSE,
  binwidth = NULL,
  bins = NULL,
  centre = NULL,
  boundary = NULL
)
}
\arguments{
\item{mapping, data, geom, position, na.rm, show.legend, inherit.aes, pad, ...}{See \code{\link[ggplot2:geom_histogram]{ggplot2::stat_bin()}}.}

\item{breaks}{Which breaks from the scale should be used? \code{"minor"} for minor
breaks, \code{"major"} for major breaks, or \code{"all"} for both.}

\item{bins, binwidth, centre, boundary}{Ignored.}
}
\value{
ggplot2 stat layer.
}
\description{
This is mostly equivalent to \code{\link[ggplot2:geom_histogram]{ggplot2::stat_bin()}} except that the bin edges
are copied from the scale breaks. For this effect to work properly, you
either need to use fixed scale breaks (e.g. using a vector instead of a
function), or use the \code{\link[=breaks_cached]{breaks_cached()}} helper.
}
\examples{
library(ggplot2)

set.seed(1)
events <- rep(as.Date("2024-01-31") - 0:30, rpois(31, 2))
df <- data.frame(date = events)

ggplot(df) +
  stat_bin_auto(aes(date)) +
  scale_x_date(breaks = week_breaks(2L, week_start = "Monday"))
}
\keyword{datasets}
