% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_handlers.R
\name{api_request_handlers}
\alias{api_request_handlers}
\alias{api_get}
\alias{api_head}
\alias{api_post}
\alias{api_put}
\alias{api_delete}
\alias{api_connect}
\alias{api_options}
\alias{api_trace}
\alias{api_patch}
\alias{api_any}
\title{Add a handler for a request}
\usage{
api_get(
  api,
  path,
  handler,
  serializers = NULL,
  parsers = NULL,
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  doc = NULL,
  route = NULL
)

api_head(
  api,
  path,
  handler,
  serializers = NULL,
  parsers = NULL,
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  doc = NULL,
  route = NULL
)

api_post(
  api,
  path,
  handler,
  serializers = NULL,
  parsers = NULL,
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  doc = NULL,
  route = NULL
)

api_put(
  api,
  path,
  handler,
  serializers = NULL,
  parsers = NULL,
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  doc = NULL,
  route = NULL
)

api_delete(
  api,
  path,
  handler,
  serializers = NULL,
  parsers = NULL,
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  doc = NULL,
  route = NULL
)

api_connect(
  api,
  path,
  handler,
  serializers = NULL,
  parsers = NULL,
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  doc = NULL,
  route = NULL
)

api_options(
  api,
  path,
  handler,
  serializers = NULL,
  parsers = NULL,
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  doc = NULL,
  route = NULL
)

api_trace(
  api,
  path,
  handler,
  serializers = NULL,
  parsers = NULL,
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  doc = NULL,
  route = NULL
)

api_patch(
  api,
  path,
  handler,
  serializers = NULL,
  parsers = NULL,
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  doc = NULL,
  route = NULL
)

api_any(
  api,
  path,
  handler,
  serializers = NULL,
  parsers = NULL,
  use_strict_serializer = FALSE,
  download = FALSE,
  async = FALSE,
  then = NULL,
  doc = NULL,
  route = NULL
)
}
\arguments{
\item{api}{A plumber2 api object to add the handler to}

\item{path}{A string giving the path the handler responds to. See Details}

\item{handler}{A handler function to call when a request is matched to the
path}

\item{serializers}{A named list of serializers that can be used to format the
response before sending it back to the client. Which one is selected is based
on the request \code{Accept} header. See \code{\link[=get_serializers]{get_serializers()}} for a helper to
construct this}

\item{parsers}{A named list of parsers that can be used to parse the
request body before passing it in as the \code{body} argument. Which one is
selected is based on the request \code{Content-Type} header. See \code{\link[=get_parsers]{get_parsers()}}
for a helper to construct this}

\item{use_strict_serializer}{By default, if a serializer that respects the
requests \code{Accept} header cannot be found, then the first of the provided ones
are used. Setting this to \code{TRUE} will instead send back a
\verb{406 Not Acceptable} response}

\item{download}{Should the response mark itself for download instead of being
shown inline? Setting this to \code{TRUE} will set the \code{Content-Disposition}
header in the response to \code{attachment}. Setting it to a string is equivalent
to setting it to \code{TRUE} but will in addition also set the default filename of
the download to the string value}

\item{async}{If \code{FALSE} create a regular handler. If \code{TRUE}, use the default
async evaluator to create an async handler. If a string, the async evaluator
registered to that name is used. If a function is provided then this is used
as the async evaluator. See the \emph{Async} section for more detail}

\item{then}{A list of function to be called once the async handler is done.
The functions will be chained using \code{\link[promises:then]{promises::then()}}. See the \emph{Async}
section for more detail}

\item{doc}{A list with the OpenAPI spec for the endpoint}

\item{route}{The route this handler should be added to. Defaults to the last
route in the stack. If the route does not exist it will be created as the
last route in the stack}
}
\value{
These functions return the \code{api} object allowing for easy chaining
with the pipe
}
\description{
This family of functions facilitates adding a request handler for a specific
HTTP method and path.
}
\section{Using annotation}{
Handlers can be specified in an annotated route file using one of the method
tags followed by the path it pertains to. You can use various tags to
descripe the handler and these will automatically be converted to OpenAPI
documentation. Further, additional tags allow you to modify the behaviour of
the handler, reflecting the arguments available in the functional approach.

\if{html}{\out{<div class="sourceCode">}}\preformatted{#* A handler for /user/<username>
#*
#* @param username:string The name of the user to provide information on
#*
#* @get /user/<username>
#*
#* @response 200:\{name:string, age:integer, hobbies:[string]\} Important
#* information about the user such as their name, age, and hobbies
#*
function(username) \{
  find_user_in_db(username)
\}
}\if{html}{\out{</div>}}

Handlers can be specified in an annotated route file using one of the method
tags followed by the path it pertains to. You can use various tags to
descripe the handler and these will automatically be converted to OpenAPI
documentation. Further, additional tags allow you to modify the behaviour of
the handler, reflecting the arguments available in the functional approach.

\if{html}{\out{<div class="sourceCode">}}\preformatted{#* A handler for /user/<username>
#*
#* @param username:string The name of the user to provide information on
#*
#* @get /user/<username>
#*
#* @response 200:\{name:string, age:integer, hobbies:[string]\} Important
#* information about the user such as their name, age, and hobbies
#*
function(username) \{
  find_user_in_db(username)
\}
}\if{html}{\out{</div>}}

You can create async handlers with \code{then} chaining using annotation, through
the \verb{@async} and \verb{@then} tags

\if{html}{\out{<div class="sourceCode">}}\preformatted{#* A handler for /user/<username>
#*
#* @param username:string The name of the user to provide information on
#*
#* @get /user/<username>
#*
#* @response 200:\{name:string, age:integer, hobbies:[string]\} Important
#* information about the user such as their name, age, and hobbies
#*
#* @async
function(username) \{
  find_user_in_db(username)
\}
#* @then
function(server, response) \{
  server$log("message", "async operation completed")
  response$set_header("etag", "abcdef")
  Next
\}
}\if{html}{\out{</div>}}
}

\section{HTTP Methods}{
The HTTP specs provide a selection of specific methods that clients can send
to the server (your plumber api). While there is no enforcement that the
server follows any conventions you should strive to create a server API that
adheres to common expectations. It is not required that a server understands
all methods, most often the opposite is true. The HTTP methods are described
below, but consider consulting \href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods}{MDN}
to get acquainted with the HTTP spec in general
\itemize{
\item \code{GET}: This method is used to request specific content and is perhaps the
most ubiquitous method in use. \code{GET} requests should only retrieve data and
should not contain any body content
\item \code{HEAD}: This method is identical to \code{GET}, except the response should only
contain headers, no body. Apart from this it is expected that a \code{HEAD}
request is identical to a \code{GET} request for the same resource
\item \code{POST}: This method delivers content, in the form of a request body, to the
server, potentially causing a change in the server. In the context of
plumber2 it is often used to call functions that require input larger than
what can be put in the URL
\item \code{PUT}: This method is used to update a specific resource on the server. In
the context of a standard plumber2 server this is rarely relevant, though
usage can come up. \code{PUT} is considered by clients to be indemptotent meaning
that sending the same \code{PUT} request multiple times have no effect
\item \code{DELETE}: This method deletes a resource and is the opposite to \code{PUT}. As
with \code{PUT} this method has limited use in most standard plumber2 servers
\item \code{CONNECT}: This method request the establishment of a proxy tunnel. It is
considered advanced use and is very unlikely to have a usecase for your
plumber2 api
\item \code{OPTIONS}: This method is used by clients to query a server about what
methods and other settings are supported on a server
\item \code{TRACE}: This method is a form of ping that should send a response
containing the request (stripped of any sensitive information). Many
servers disallow this method due to security concerns
\item \code{PATCH}: This method is like \code{PUT} but allows partial modification of a
resource
}

Apart from the above, plumber2 also understands the \code{ANY} method which
responds to requests to any of the above methods, assuming that a specific
handler for the method is not found. As the semantics of the various methods
are quite different an \code{ANY} handler should mainly be used for rejections or
for setting specific broad headers on the response, not as the main handler
for the request
}

\section{The Path}{
The path defines the URL the request is being made to with the root removed.
If your plumber2 server runs from \verb{http://example.com/api/} and a request is
made to \verb{http://example.com/api/user/thomas/}, then the path would be
\verb{user/thomas/}. Paths can be static like the prior example, or dynamic as
described below:
\subsection{Path arguments}{

Consider you have a bunch of users. It would be impractical to register a
handler for each one of them. Instead you can use a dynamic path like with
the following syntax: \verb{user/<username>/}. This path would be matched to any
requests made to \verb{user/..something../}. The actual value of \code{..something..}
(e.g. \code{thomas}) would be made available to the handler (see below). A path
can contain multiple arguments if needed, such as
\verb{user/<username>/settings/<setting>/}
}

\subsection{Path wildcards}{

Apart from path arguments it is also possible to be even less specific by
adding a wildcard to the path. The path \verb{user/*} will match both
\verb{user/thomas/}, \verb{user/thomas/settings/interests/}, and anything other path
that begins with \verb{user/}. As with arguments a path can contain multiple
wildcards but the use of these have very diminishing returns. Contrary to
path arguments the value(s) corresponding to \code{*} is not made available to the
handler.
}

\subsection{Path Priority}{

With the existence of path arguments and wildcards it is possible that
multiple handlers in a route can be matched to a single request. Since only
one can be selected we need to determine which one wins. The priority is
based on the specificity of the path. Consider a server containing the
following handler paths: \verb{user/thomas/}, \verb{user/<username>/},
\verb{user/<username>/settings/<setting>/}, \verb{user/*}. These paths will have the
following priority:
\enumerate{
\item \verb{user/<username>/settings/<setting>/}
\item \verb{user/thomas/}
\item \verb{user/<username>/}
\item \verb{user/*}
}

The first spot is due to the fact that it is the path with the most elements
so it is deemed most specific. For the remaining 3 they all have the same
number of elements, but static paths are considered more specific than
dynamic paths, and path arguments are considered more specific than
wildcards.

A request made to \code{user/carl} will thus end up in the third handler, while a
request made to \code{user/thomas} will end up in the second. This ordering makes
it possible to both provide default handlers as well as specialisations for
specific paths.
}
}

\section{The Handler}{
The handler is a standard R function that is called when a request is made
that matches the handlers path (unless a more specific handler path exists —
see above). A handler function can perform any operation a normal R function
can do, though you should consider strongly the security implications of your
handler functions. However, there are certain expectations in plumber around
the arguments a handler function takes and the return value it provides
\subsection{Handler Arguments}{

The handler function can take one or more of the following arguments.
\itemize{
\item \strong{Path arguments}: Any path arguments are passed on to the handler. If a
handler is registered for the following path
\verb{user/<username>/settings/<setting>/} and it handles a request to
\verb{user/thomas/settings/interests/} then it will be called with
\verb{username = "thomas", setting = "interest"}
\item \code{request}: The request the handler is responding to as a \link[reqres:Request]{reqres::Request}
object
\item \code{response}: The response being returned to the client as a
\link[reqres:Response]{reqres::Response} object
\item \code{server}: The \link{Plumber2} object representing your server implementation
\item \code{client_id}: A string uniquely identifying the session the request comes
from
\item \code{query}: A list giving any additional arguments passed into the handler as
part of the url query string
\item \code{body}: The request body, parsed as specified by the provided parsers
}
}

\subsection{Handler Return Value}{

Handlers can return a range of different value types, which will inform
plumber2 what to do next:
\subsection{Returning \code{Next} or \code{Break}}{

These two control objects informs plumber2 to either proceed handling the
request (\code{Next}) or return the response as is, circumventing any remaining
routes (\code{Break})
}

\subsection{Returning \code{NULL} or the \code{response} object}{

This is the same as returning \code{Next}, i.e. it signals that handling can
proceed
}

\subsection{Returning a ggplot2 object}{

If you return a ggplot2 object it will get plotted for you (and added to the
response assuming a graphics serializer is provided) before handling
continues
}

\subsection{Returning any other value}{

Any kind of value returned that is not captured by the above description will
be set to the response body (overwriting what was already there) and
handling is then allowed to continue
}

}

\subsection{Handler conditions}{

Like any function in R, a handler may need to signal that something happened,
either by throwing an error or warning or by emitting a message. You can use
\code{\link[=stop]{stop()}}, \code{\link[=warning]{warning()}}, and \code{\link[=message]{message()}} as you are used to. For all of them,
the condition message will end up in the log. Further, for \code{stop()} any
further handling of the request will end and a \verb{500 Internal Error} response
is returned. To take more control over problems you can use the
\code{\link[=abort_status]{abort_*()}} family of conditions from reqres. Like \code{stop()}
they will halt any further processing, but they also allow control over what
kind of response is sent back, what kind of information about the issue is
communicated to the client, and what kind of information is logged
internally. The response they send back (except for \code{abort_status()}) all
adhere to the HTTP Problem spec defined in
\href{https://datatracker.ietf.org/doc/html/rfc9457}{RFC 9457}.

While it may feel like a good idea to send a detailed error message back to
the client it is often better to only inform the client of what they need to
change to solve the issue. Too much information about internal implementation
details can be a security risk and forwarding internal errors to a client can
help inform the client about how the server has been implemented.
}
}

\section{Async handling}{
plumber2 supports async handling of requests in one of two ways:
\enumerate{
\item The handler you provide returns a promise object
\item You set \code{async = TRUE} (or the name of a registered async evaluator) when
adding the handler
}

For 1), there is no more to do. You have full custody over the created
promise and any \code{then()}-chaining that might be added to it. For 2) it is a
bit different. In that case you provide a regular function and plumber2 takes
care of converting it to a promise. Due to the nature of promises a handler
being converted to a promise can't take \code{request}, \code{response}, and \code{server}
arguments, so if you need to manipulate these you need to use \code{then} (more on
this shortly). The async handler should yield the value that the response
should ultimately get assigned to the body or have plotting side effects (in
which case the plot will get added to the response).
\subsection{Async chaining}{

Because you can't manipulate \code{request} \code{response}, or \code{server} in the async
handler it may be needed to add operations to perform once the async handler
has finished. This can be done through the \code{then} argument (or using the
\verb{@then} tag in annotated route files). This takes a list of functions to
chain to the promise using \code{\link[promises:then]{promises::then()}}. Before the \code{then} chain is
executed the response will get the return value of the main handler asigned
to the body. Each \code{then} call will receive the same arguments as a standard
request handler as well as \code{result} which will hold the return value of the
previous handler in the chain. For the first \code{then} call \code{result} will be a
boolean signalling if the async handler wants request handling to proceed to
the next route or terminate early. The last call in the chain must return
\code{Next} or \code{Break} to signal if processing should be allowed to continue to
the next route.
}
}

\examples{
# Standard use
api() |>
  api_get("/hello/<name:string>", function(name) {
    list(
      msg = paste0("Hello ", name, "!")
    )
  })

# Specify serializers
api() |>
  api_get(
    "/hello/<name:string>",
    function(name) {
      list(
        msg = paste0("Hello ", name, "!")
      )
    },
    serializers = get_serializers(c("json", "xml"))
  )

# Request a download and make it async
api() |>
  api_get(
    "/the_plot",
    function() {
      plot(1:10, 1:10)
    },
    serializers = get_serializers(c("png", "jpeg")),
    download = TRUE,
    async = TRUE
  )

}
\seealso{
Other Request Handlers: 
\code{\link{api_request_header_handlers}}
}
\concept{Request Handlers}
