% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers_replacer.R
\name{outliers_replacer}
\alias{outliers_replacer}
\title{A Outliers Replacer Function}
\usage{
outliers_replacer(value, date, threshold = 5, sum_percent = 100)
}
\arguments{
\item{value}{pollen concentration values}

\item{date}{dates}

\item{threshold}{a number indicating how many times outlying value needs to be larger than the background to be replaced (default is 5)}

\item{sum_percent}{a sum_percent parameter}
}
\value{
a new data.frame object with replaced outliers
}
\description{
This function finds outliers in pollen time-series and replaces them with background values
}
\examples{

data(pollen_count)
df <- subset(pollen_count, site=='Shire')
new_df <- outliers_replacer(df$birch, df$date)
identical(df, new_df)

library('purrr')
new_pollen_count <- pollen_count \%>\% split(., .$site) \%>\%
       map_df(~outliers_replacer(value=.$hazel, date=.$date, threshold=4))

}
\references{
Kasprzyk, I. and A. Walanus.: 2014. Gamma, Gaussian and Logistic Distribution Models for Airborne Pollen Grains and Fungal Spore Season Dynamics, Aerobiologia 30(4), 369-83.
}
