% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReflexiveClosure.R
\name{ReflexiveClosure}
\alias{ReflexiveClosure}
\title{Computing reflexive closure.}
\usage{
ReflexiveClosure(set, rel)
}
\arguments{
\item{set}{A list of character strings (the names of the elements of the set, on which the binary relation is defined).}

\item{rel}{A two-columns character matrix, each row comprising an element (pair) of the relation.}
}
\value{
A reflexive binary relation, as a two-columns character matrix
(each row comprises an element (pair) of the transitivity closed relation).
}
\description{
Computes the reflexive closure of the input binary relation.
}
\examples{
set<-c("a", "b", "c", "d", "e")

rel <- matrix(c(
  "a", "b",
  "c", "b",
  "d", "a",
  "c", "a",
  "a", "a",
  "d", "d"
), ncol = 2, byrow = TRUE)

r.clo<-ReflexiveClosure(set, rel)

}
