% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F1Test.R
\name{F1Test}
\alias{F1Test}
\title{F1 test}
\usage{
F1Test(X, Y, nperm = 200, A, randomization = FALSE,
Y.prob = FALSE, eps = 0.01, scaling = 'auto-scaling',
post.transformation = TRUE,cross.validation = FALSE,...)
}
\arguments{
\item{X}{data matrix where columns represent the \eqn{p} variables and
rows the \eqn{n} observations.}

\item{Y}{data matrix where columns represent the two classes and
rows the \eqn{n} observations.}

\item{nperm}{number of permutations. Default to 200.}

\item{A}{number of score components}

\item{randomization}{Boolean value. Default to \code{FALSE}. If \code{TRUE} the permutation p-value is computed}

\item{Y.prob}{Boolean value. Default \code{FALSE}. IF \code{TRUE} \code{Y} is a probability vector}

\item{eps}{Default 0.01. \code{eps} is used when \code{Y.prob = FALSE} to transform \code{Y} in a probability vector}

\item{scaling}{Type of scaling, one of
\code{c('auto-scaling', 'pareto-scaling', 'mean-centering')}. Default 'auto-scaling'.}

\item{post.transformation}{Boolean value. \code{TRUE} if you want to apply post transformation. Default \code{TRUE}}

\item{cross.validation}{Boolean value. Default \code{FALSE}. \code{TRUE} if you want to compute the observed test statistic by Nested cross-validation}

\item{...}{additional arguments related to \code{cross.validation}. See \code{\link{repeatedCV_test}}}
}
\value{
List with the following objects:
\describe{
  \item{pv}{raw p-value. It equals \code{NA} if \code{randomization = FALSE}}
  \item{pv_adj}{adjusted p-value. It equals \code{NA} if \code{randomization = FALSE}}
  \item{test}{estimated test statistic}
}
}
\description{
Performs permutation-based test based on F1
}
\examples{
datas <- simulatePilotData(nvar = 30, clus.size = c(15,15),m = 6,nvar_rel = 5,A = 1)
out <- F1Test(X = datas$X, Y = datas$Y, A = 1)
out
}
\references{
For the general framework of power analysis for PLS-based methods see:

Andreella, A., Fino, L., Scarpa, B., & Stocchero, M. (2024). Towards a power analysis for PLS-based methods. arXiv preprint \url{https://arxiv.org/abs/2403.10289}.
}
\seealso{
Other test statistics implemented: \code{\link{mccTest}}, \code{\link{scoreTest}},
\code{\link{dQ2Test}}, \code{\link{sensitivityTest}},\code{\link{AUCTest}}, \code{\link{R2Test}},
\code{\link{specificityTest}}, \code{\link{FMTest}}.
}
\author{
Angela Andreella
}
