% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal-plot-breaks.R, R/cal-plot-logistic.R,
%   R/cal-plot-windowed.R
\name{.cal_table_breaks}
\alias{.cal_table_breaks}
\alias{.cal_table_logistic}
\alias{.cal_table_windowed}
\title{Probability Calibration table}
\usage{
.cal_table_breaks(
  .data,
  truth = NULL,
  estimate = NULL,
  .by = NULL,
  num_breaks = 10,
  conf_level = 0.9,
  event_level = c("auto", "first", "second"),
  ...
)

.cal_table_logistic(
  .data,
  truth = NULL,
  estimate = NULL,
  .by = NULL,
  conf_level = 0.9,
  smooth = TRUE,
  event_level = c("auto", "first", "second"),
  ...
)

.cal_table_windowed(
  .data,
  truth = NULL,
  estimate = NULL,
  .by = NULL,
  window_size = 0.1,
  step_size = window_size/2,
  conf_level = 0.9,
  event_level = c("auto", "first", "second"),
  ...
)
}
\arguments{
\item{.data}{An ungrouped data frame object containing predictions and
probability columns.}

\item{truth}{The column identifier for the true class results
(that is a factor). This should be an unquoted column name.}

\item{estimate}{A vector of column identifiers, or one of \code{dplyr} selector
functions to choose which variables contains the class probabilities. It
defaults to the prefix used by tidymodels (\code{.pred_}). The order of the
identifiers will be considered the same as the order of the levels of the
\code{truth} variable.}

\item{.by}{The column identifier for the grouping variable. This should be
a single unquoted column name that selects a qualitative variable for
grouping. Default to \code{NULL}. When \code{.by = NULL} no grouping will take place.}

\item{num_breaks}{The number of segments to group the probabilities. It
defaults to 10.}

\item{conf_level}{Confidence level to use in the visualization. It defaults
to 0.9.}

\item{event_level}{single string. Either "first" or "second" to specify which
level of truth to consider as the "event". Defaults to "auto", which allows
the function decide which one to use based on the type of model (binary,
multi-class or linear)}

\item{...}{Additional arguments passed to the \code{tune_results} object.}
}
\description{
Calibration table functions. They require a data.frame that
contains the predictions and probability columns. The output is another
\code{tibble} with segmented data that compares the accuracy of the probability
to the actual outcome.
}
\details{
\itemize{
\item \code{.cal_table_breaks()} - Splits the data into bins, based on the
number of breaks provided (\code{num_breaks}). The bins are even ranges, starting
at 0, and ending at 1.
\item \code{.cal_table_logistic()} - Fits a logistic spline regression (GAM)
against the data. It then creates a table with the predictions based on 100
probabilities starting at 0, and ending at 1.
\item \code{.cal_table_windowed()} - Creates a running percentage of the
probability that moves across the proportion of events.
}
}
\examples{
.cal_table_breaks(
  segment_logistic,
  Class,
  .pred_good
)

.cal_table_logistic(
  segment_logistic,
  Class,
  .pred_good
)

.cal_table_windowed(
  segment_logistic,
  Class,
  .pred_good
)
}
\keyword{internal}
