% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/dates.R
\name{adjust_cpp}
\alias{adjust_cpp}
\alias{adjust}
\title{Compute adjusted dates}
\usage{
adjust_cpp(dates, bdc = 0L)

adjust(dates, bdc = c("Following", "ModifiedFollowing", "Preceding",
  "ModifiedPreceding", "Unadjusted", "HalfMonthModifiedFollowing", "Nearest"))
}
\arguments{
\item{dates}{A Date vector with dates}

\item{bdc}{A character variable describing one of several supported values,
the C++ version implements expects a corresponding integer value}
}
\value{
A Date vector with dates adjust according to business-day convention
}
\description{
Adjust a vector of dates following a business-day convention
}
\details{
This function takes a vector of dates and returns another vector of dates
of the same length returning at each position the adjusted date according
to the selected business-day convention. Currently supported values for
the business day convention are (starting from zero):
\sQuote{Following}, \sQuote{ModifiedFollowing}, \sQuote{Preceding},
\sQuote{ModifiedPreceding}, \sQuote{Unadjusted}, \sQuote{HalfModifiedFollowing}
and \sQuote{Nearest}.
}
\examples{
adjust(Sys.Date()+0:6)
}
