% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel_helpers.R
\name{modify_output_style}
\alias{modify_output_style}
\title{Modify Style for 'Excel' Table Outputs}
\usage{
modify_output_style(style_to_modify, ...)
}
\arguments{
\item{style_to_modify}{A pre created style where only certain elements should be
modified while the rest is kept as is.}

\item{...}{Pass in names and corresponding new values for existing style elements.}
}
\value{
Returns a modified list of named style options.
}
\description{
Modify a previously created style with \code{\link[=excel_output_style]{excel_output_style()}}.
}
\details{
\code{\link[=modify_output_style]{modify_output_style()}} is based on the Output Delivery System (ODS) in 'SAS',
which provides efficient and readable ways to set up different table styles.

With the output style you have full control over the table design. There is no
need to think about calculating the right place to input a background color or a
border of a certain type and how to do this in a loop for multiple cells. Just
input colors, borders, font styles, etc. for the different table parts and everything
else is handled by the functions capable of using styles.

The concept basically is: design over complex calculations.
}
\examples{
# For default values
excel_style <- excel_output_style()

# Set specific options, the rest will be kept as is
excel_style <- excel_style |> modify_output_style(sheet_name      = "Sheet",
                                                  title_font_bold = FALSE)

# For cells with no background color pass an empty string
excel_style <- excel_style |> modify_output_style(table_back_color = "")

}
\seealso{
Creating a custom table style: \code{\link[=excel_output_style]{excel_output_style()}},
\code{\link[=number_format_style]{number_format_style()}}, \code{\link[=modify_number_formats]{modify_number_formats()}}.

Global style options: \code{\link[=set_style_options]{set_style_options()}}, \code{\link[=set_variable_labels]{set_variable_labels()}}, \code{\link[=set_stat_labels]{set_stat_labels()}}.

Functions that can handle styles: \code{\link[=frequencies]{frequencies()}}, \code{\link[=crosstabs]{crosstabs()}}, \code{\link[=any_table]{any_table()}},
\code{\link[=export_with_style]{export_with_style()}}
}
