% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verification.R
\name{verify.glm}
\alias{verify.glm}
\title{Enhances a "glm" object with verification data.}
\usage{
\method{verify}{glm}(x, newdata, precision = 1e-13, zeroThreshold = 1e-13, ...)
}
\arguments{
\item{x}{A "glm" object.}

\item{newdata}{The verification dataset.}

\item{precision}{Maximal relative error.}

\item{zeroThreshold}{Maximal absolute error near the zero value.}

\item{...}{Further arguments.}
}
\description{
Enhances a "glm" object with verification data.
}
\examples{
\donttest{
library("mlbench")
library("r2pmml")

data(BostonHousing)
housing.glm = glm(medv ~ ., data = BostonHousing, family = "gaussian")
housing.glm = verify(housing.glm, newdata = BostonHousing[sample(nrow(BostonHousing), 10), ])
# Please uncomment the next line
#r2pmml(housing.glm, file.path(tempdir(), "Housing-GLM-verified.pmml"))
}
}
